% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slim.R
\name{slim}
\alias{slim}
\title{Fit Singular Linear Models}
\usage{
slim(formula, data, covariance = "randomwalk", limit = ~1,
  contrasts = NULL)
}
\arguments{
\item{formula}{a model formula for the fixed effects}

\item{data}{a 'data.table' with two keys, respectively identifying subjects
and observation times}

\item{covariance}{an R object for which a 'list_covariances' method exists.
Options include a character string such as "identity", "randomwalk" (the
default), "brownian" or "pascal"; a list of covariance matrices; a function
to be used in 'outer' and applied to the observation times; or a 'jmcmMod'
or 'lmerMod' model fit.}

\item{limit}{a one-sided model formula for the (thin) Cholesky factor of the
limiting covariance matrix (default ~ 1, so the limiting covariance matrix
is the matrix of ones)}

\item{contrasts}{an optional list. See the 'contrasts.arg' argument of
'model.matrix.default'.}
}
\value{
an object of class 'slim'
}
\description{
Fit a singular linear model to longitudinal data.
}
\examples{
slim_fit <- slim(renalfn ~ group + month, dialysis)
summary(slim_fit)

if(require("lme4")) {
  lmer_fit <- lmer(renalfn ~ group + month + (1 + month | id), dialysis)
  slim_fit <- slim(renalfn ~ 1 + group + month, dialysis, covariance = lmer_fit)
  summary(slim_fit)
  summary(slim_fit, empirical = FALSE)
}

if(require("jmcm")) {
  jmcm_fit <- jmcm(renalfn | id | month ~ group | 1, dialysis,
    triple = rep(2L, 3), cov.method = "mcd")
  slim_fit <- slim(renalfn ~ group + month, dialysis, covariance = jmcm_fit)
  summary(slim_fit)
  summary(slim_fit, empirical = FALSE)
}
}
