% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{hillclimbplot}
\alias{hillclimbplot}
\alias{hillclimbplot.slouch}
\title{Plot the hillclimber trajectory}
\usage{
hillclimbplot(x, ...)

\method{hillclimbplot}{slouch}(x, ...)
}
\arguments{
\item{x}{An object of class 'slouch'}

\item{...}{Additional arguments passed to 'plot.default(...)'}
}
\description{
Plot the hillclimber trajectory
}
\section{Methods (by class)}{
\itemize{
\item \code{hillclimbplot(slouch)}: Hillclimbplot for the 'slouch object'

}}
\examples{
library(slouch)
library(ape)

data(neocortex)
data(artiodactyla)

neocortex <- neocortex[match(artiodactyla$tip.label, neocortex$species), ]

m0 <- slouch.fit(phy = artiodactyla,
                species = neocortex$species,
                response = neocortex$neocortex_area_mm2_log_mean,
                mv.response = neocortex$neocortex_se_squared,
                hillclimb = TRUE)
                
hillclimbplot(m0)

m1 <- brown.fit(phy = artiodactyla,
               species = neocortex$species,
               response = neocortex$neocortex_area_mm2_log_mean,
               mv.response = neocortex$neocortex_se_squared,
               hillclimb = TRUE)
               
hillclimbplot(m1)
}
