% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_rename_columns.R
\name{ss_rename_columns}
\alias{ss_rename_columns}
\title{Rename columns}
\usage{
ss_rename_columns(ss_id, new_names, column_names = NULL, column_locs = NULL)
}
\arguments{
\item{ss_id}{The sheetId, permalink, or name of the Smartsheet sheet to read}

\item{new_names}{A character vector of new names for the chosen columns}

\item{column_names}{A vector of names of columns within the sheet to be replaced}

\item{column_locs}{A vector of locations of columns within the sheet to be replaced}
}
\value{
A list of ss_resp objects
}
\description{
Rename a set of columns. One of the following must be true:
\itemize{
\item{column_names is not NULL}
\item{column_locs is not NULL, or}
\item{new_names is the same length as the number of columns of the ss_id sheet}
}
}
\examples{
\dontrun{
df = data.frame("PK"=character(), "temp"=character())
ss_id = ss_sheetid(ss_write_sheet(paste0("smartsheetr-example-",random_sheet_name()), data=df))
ss_rename_columns(ss_id, new_names="FK", column_names="temp")
ss_read_sheet(ss_id)
# clean up
ss_delete_sheet(ss_id)
}

}
