% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_write_sheet.R
\name{ss_write_sheet_columns}
\alias{ss_write_sheet_columns}
\title{Write the initial columns for the a sheet}
\usage{
ss_write_sheet_columns(sheet_name, data = data.frame(PK = character()))
}
\arguments{
\item{sheet_name}{A character vector}

\item{data}{A data frame of columns to be added}
}
\value{
A \code{ss_createsheet_resp} object
}
\description{
Write the initial columns for the a sheet
}
\details{
The \href{https://smartsheet.redoc.ly}{Smartsheet API 2.0} uses two calls for creating a sheet with data.
The first is a call to create a sheet and populate the columns (analogous to
\link{ss_write_sheet_columns}). The second is to add rows (analogous to
\link{ss_add_rows}). \link{ss_write_sheet} accomplishes both of these steps.
}
\examples{
\dontrun{
temp_sheet_name = paste0("smartsheetr-example-",random_sheet_name())
ss_id = ss_sheetid(ss_write_sheet_columns(temp_sheet_name, data=mtcars))
ss_read_sheet(ss_id) # No rows. Use ss_write_sheet() to write the full data frame
# clean up
ss_delete_sheet(ss_id)
}

}
