% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{findDampFactor}
\alias{findDampFactor}
\title{findDampFactor}
\usage{
findDampFactor(sigma, factor = 1.05, d_cutoff = 1e-60, startValue = 1e-04)
}
\arguments{
\item{sigma}{covariance matrix}

\item{factor}{step factor}

\item{d_cutoff}{determinant cutoff}

\item{startValue}{starting value to initialize the finding}
}
\description{
find dampening factor
}
\examples{
data(seqfishplus)
k<-dim(seqfishplus$mu)[2]
damp<-array(0, c(k))
for(i in 1:k){
    di<-findDampFactor(seqfishplus$sigma[,,i], factor=1.05, d_cutoff=1e-5, startValue=0.0001)
    damp[i]<-ifelse(is.null(di), 0, di)
} 
}
