% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_algorithm.R
\name{smooth_algorithm}
\alias{smooth_algorithm}
\title{Apply Smooth Algorithm in a Dataset}
\usage{
smooth_algorithm(id, treatment, day, N, width = 61)
}
\arguments{
\item{id}{Unique identifier of the patient.}

\item{treatment}{Name of the drug used.}

\item{day}{Day of the treatment.}

\item{N}{Number of drugs used in the treatment.}

\item{width}{An integer specifying the window width (in numbers of days, 61 by default).}
}
\value{
A data.frame with the following structure:
\describe{
\item{id}{A character vector representing the unique identifier for each patient.}
\item{day}{A character vector representing the date when the treatment was administered to the patients.}
\item{treatment}{A character vector representing the type of treatment given to each patient.}
\item{smoothed_treatment}{A character vector representing the smoothed treatment given to each patient.}
}
}
\description{
Description part
}
\examples{

library(smoothy)
library(dplyr)

data(drugstreatment)

df <- drugstreatment |>
  filter(id == "01f13c15-d9f1-4106-a04f-976c457edd0a")

structured_df <- smooth_parse(
  id = df$id,
  start_date = df$start_date,
  end_date = df$end_date,
  drug = df$drug,
  study_from = "1970-01-01",
  study_to = "1975-01-01"
)

head(structured_df)

id = structured_df$id
treatment = structured_df$treatment
day = structured_df$day
N = structured_df$N
width = 61

smoothed <- smooth_algorithm(id = id, treatment = treatment, day = day, N = N, width = width)
head(smoothed)

}
