% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_smos.R
\name{extract_smos}
\alias{extract_smos}
\title{Extract BEC-SMOS soil moisture estimates for specific geographical locations}
\usage{
extract_smos(
  data,
  lat,
  lon,
  save = FALSE,
  dir = NULL,
  filename = "smosr_output.csv"
)
}
\arguments{
\item{data}{a character vector as produced by \code{list_smos()} containing
links to the data files on the local computer.}

\item{lat}{a numeric vector containing latitudes of geographical locations to
extract the data from (in ‘latlon’ projection).}

\item{lon}{a numeric vector containing longitudes of geographical locations
to extract the data from (in ‘latlon’ projection).}

\item{save}{a logical vector indicating whether the output should be saved as
a CSV file. Default is \code{FALSE}.}

\item{dir}{a character string specifying a path to a local directory in which
to save the CSV file with the output. Default value is \code{NULL} meaning
that the file is stored in a temporary directory of the current R session.}

\item{filename}{a character string naming the CSV file for saving the output.
If \code{save} = \code{TRUE} and no \code{filename} is specified by the user,
the data is saved in a file with a generic name ‘smosr_output.csv’.}
}
\value{
a data.matrix with the relevant information as described in Details.
}
\description{
This function facilitates reading of the original BEC-SMOS soil moisture data
files and extracting relevant information for specific geographical locations
by using Lat/Lon coordinates in decimal degrees.
}
\details{
This function reads the original BEC-SMOS soil moisture data files in NetCDF
format, converts data from EASE-2 grid cells to geographic coordinates, and
extracts relevant information for Lat/Lon locations specified by the user.

The data retrieved from each data file includes:

- the coordinates of spatial points (Lon and Lat) from which the data were
extracted;

- frequency and SMOS orbit of each file over which the function iterated;

- date and time when the data was obtained;

- soil moisture estimate (SM);

- quality assurance (QA) flag corresponding to each SM estimate.

The output of this function could be saved as a CSV file.
}
\examples{
\dontrun{
# to iterate over a list of BEC-SMOS data files produced by list_smos() and
# extract soil moisture estimates for the specified geographical locations
smos_files <- list_smos()
lat <- c(40.42, 41.90, 48.86, 52.50, 59.91)
lon <- c(-3.70, 12.50, 2.35, 13.40, 10.75)
sm_estimates <- extract_smos(data = smos_files, lat = lat, lon = lon)
}

}
\references{
Pablos M, Gonzalez-Haro C, Portal G, Piles M, Vall-llossera M,
Portabella M (2022). SMOS L4 Surface Soil Moisture downscaled maps at 1 km
EASE-2 (reprocessed mode) (V.6.0) [Dataset].
}
