% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{diffnet_to_snQTL_stats}
\alias{diffnet_to_snQTL_stats}
\title{Test statistics for snQTL}
\usage{
diffnet_to_snQTL_stats(
  diffnet_list,
  method = c("sum", "sum_square", "max", "tensor"),
  rho = 1000,
  sumabs = 0.2,
  niter = 20,
  trace = FALSE,
  tensor_iter = 20,
  tensor_tol = 10^(-3),
  tensor_seed = NULL
)
}
\arguments{
\item{diffnet_list}{list, a list of p-by-p differential networks}

\item{method}{character, the choice of test statistics; see "details"}

\item{rho}{number, a large positive constant adding to the diagonal elements to ensure positive definiteness in symmetric matrix spectral decomposition}

\item{sumabs}{number, the number specify the sparsity level in the matrix/tensor eigenvector; \code{sumabs} takes value between \eqn{1/sqrt(p)} and 1, where \eqn{p} is the dimension; \code{sumabs}\eqn{*sqrt(p)} is the upperbound of the L1 norm of the leading matrix/tensor eigenvector (see \code{symmPMD()})}

\item{niter}{integer, the number of iterations to use in the PMD algorithm (see \code{symmPMD()})}

\item{trace}{logic variable, whether to trace the progress of PMD algorithm (see \code{symmPMD()})}

\item{tensor_iter}{integer, the maximal number of iteration in SSTD algorithm (see \code{max_iter} in \code{SSTD()})}

\item{tensor_tol}{number, a small positive constant for error difference to indicate the SSTD convergence (see \code{tol} in \code{SSTD()})}

\item{tensor_seed}{number, the seed to generate random initialization for SSTD algorithm}
}
\value{
a list containing the following:

\item{method}{character, recall of the choice of test statistics}

\item{stats}{number, the calculated test statistics with given network list and choices}

\item{decomp_result}{list, if \code{method = c("sum", "sum_square", "max")}, the matrix decomposition components for all pairwise differential networks are recorded; if \code{method = "tensor"}, the tensor decomposition components for the differential tensor are recorded}
}
\description{
Generate snQTL test statistics from a given list of differential networks.
This function takes a list of differential networks, the choice of test statistics, and other computational tuning parameters as inputs.
Outputs include the calculated statistics, recall of the choice, and the decomposition components associated with the statistics.
}
\details{
The list \code{diffnet_list} records the pairwise differential networks \eqn{D_{AB}, D_{AH}, D_{AB}}. This package provides four options for test statistics:

\enumerate{
\item{sum}, the sum of sparse leading matrix eigenvalues (sLMEs) of all pairwise differential networks:

\deqn{Stat_sum =  \lambda(D_{AB}) + \lambda(D_{AH}) + \lambda(D_{BH}),}

where \eqn{\lambda} refers to the sLME operation with given sparsity level set up by \code{sumabs}.

\item{sum_square}, the sum of squared sLMEs:

\deqn{Stat_sumsquare =  \lambda^2(D_{AB}) + \lambda^2(D_{AH}) + \lambda^2(D_{BH}).}

\item{max}, the maximal of sLMEs:

\deqn{Stat_max = \max(\lambda(D_{AB}), \lambda(D_{AH}), \lambda(D_{BH})).}

\item{tensor}, the sparse leading tensor eigenvalue (sLTE) of the differential tensor:

\deqn{Stat_tensor = \Lambda(\mathcal{D}),}

where \eqn{\Lambda} refers to the sLTE operation with given sparsity level set up by \code{sumabs},
and \eqn{\mathcal{D}} is the differential tensor composed by stacking three pairwise differential networks.
}

The sparse symmetric matrix decomposition is implemented by \code{symmPMD()} with parameters \code{rho, sumabs, niter, trace}.
The sparse symmetric tensor decomposition is implemented by \code{SSTD()}.
Since \code{symmPMD()} is used in \code{SSTD()}, parameters for \code{symmPMD()} are used for \code{SSTD()}.
While parameters \code{tensor_iter, tensor_tol, tensor_seed} should be uniquely defined for \code{tensor} method.
}
\references{
Hu, J., Weber, J. N., Fuess, L. E., Steinel, N. C., Bolnick, D. I., & Wang, M. (2025). A spectral framework to map QTLs affecting joint differential networks of gene co-expression. PLOS Computational Biology, 21(4), e1012953.
}
