% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge.regression.R
\name{ridge.regression}
\alias{ridge.regression}
\title{Ridge Regression with Automatic Lambda Selection}
\usage{
ridge.regression(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  lambda.range = c(1e-04, 100),
  folds = 5,
  ...
)
}
\arguments{
\item{formula}{A model formula like `y ~ x1 + x2`. Mutually exclusive with `x`/`y`.}

\item{data}{A data frame containing all variables used in the formula.}

\item{x}{A numeric matrix of predictor variables (n × p). Used when formula is not provided.}

\item{y}{A numeric vector of response variables (n × 1). Used when formula is not provided.}

\item{lambda.range}{A numeric vector of length 2 specifying the interval for lambda optimization.
Default: `c(1e-4, 100)`.}

\item{folds}{An integer specifying the number of cross-validation folds. Default: `5`.}

\item{...}{Additional arguments passed to internal methods.}
}
\value{
A `ridge.model` object containing:
\describe{
  \item{coefficients}{Final ridge coefficients (no intercept)}
  \item{std_errors}{Standard errors of the coefficients}
  \item{intercept}{Intercept term (from y centering)}
  \item{optimal.lambda}{Best lambda minimizing CV-MSE}
  \item{cv.ms}{Minimum CV-MSE achieved}
  \item{cv.results}{Data frame with lambda and CV-MSE pairs}
  \item{x.scale}{Standardization info: mean and sd for each predictor}
  \item{y.center}{Centering constant for y}
  \item{fitted.values}{Final model predictions on training data}
  \item{residuals}{Training residuals (y - fitted)}
  \item{call}{Matched call (for debugging)}
  \item{method}{Always "ridge"}
  \item{folds}{Number of CV folds used}
  \item{formula}{Stored if formula interface used}
  \item{terms}{Stored if formula interface used}
}
}
\description{
Performs ridge regression with automatic selection of the optimal regularization parameter `lambda`
by minimizing k-fold cross-validated mean squared error (CV-MSE) using Brent's method.
Supports both formula and matrix interfaces.
}
\details{
This function implements ridge regression with automatic hyperparameter tuning. The algorithm:
\itemize{
  \item Standardizes predictor variables (centers and scales)
  \item Centers the response variable
  \item Uses k-fold cross-validation to find the optimal lambda
  \item Fits the final model with the optimal lambda
  \item Returns a structured object for prediction and analysis
}

The ridge regression solution is computed using the closed-form formula:
\eqn{\hat{\beta} = (X^T X + \lambda I)^{-1} X^T y}
}
\examples{
\dontrun{
# Formula interface
model1 <- ridge.regression(mpg ~ wt + hp + disp, data = mtcars)

# Matrix interface
X <- as.matrix(mtcars[, c("wt", "hp", "disp")])
y <- mtcars$mpg
model2 <- ridge.regression(x = X, y = y)

# Custom lambda range and folds
model3 <- ridge.regression(mpg ~ .,
    data = mtcars,
    lambda.range = c(0.1, 10), folds = 10
)
}

}
\references{
Hoerl, A. E., & Kennard, R. W. (1970). Ridge regression: Biased estimation for nonorthogonal problems.
\emph{Technometrics}, 12(1), 55-67.
}
\seealso{
\code{\link{predict.ridge.model}}
}
