% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_analysis.r
\name{soc.mca}
\alias{soc.mca}
\title{soc.mca
\code{soc.mca} performs a specific multiple correspondence analysis on a data.frame of factors, where cases are rows and columns are variables.}
\usage{
soc.mca(
  active,
  sup = NULL,
  identifier = NULL,
  passive = getOption("passive", default = "Missing"),
  weight = NULL,
  Moschidis = FALSE,
  detailed.results = FALSE
)
}
\arguments{
\item{active}{Defines the active modalities in a data.frame with rows of individuals and columns of factors, without NA's'. Active can also be a named list of data.frames. The data.frames will correspond to the analytical headings.}

\item{sup}{Defines the supplementary modalities in a data.frame with rows of individuals and columns of factors, without NA's}

\item{identifier}{A single vector containing a single value for each row/individual in x and sup. Typically a name or an id.number.}

\item{passive}{A single character vector with the full or partial names of the passive modalities. All names that have a full or partial match will be set as passive.}

\item{weight}{a numeric vector with the weights for the individual rows. The weight is normalized afterwards.}

\item{Moschidis}{If TRUE adjusts contribution values for rare modalities. see \link{moschidis}.}

\item{detailed.results}{If FALSE the result object is trimmed to reduce its memory footprint.}
}
\value{
\item{nd}{Number of active dimensions}
 \item{n.ind}{The number of active individuals}
 \item{n.mod}{The number of active modalities}
 \item{eigen}{Eigenvectors}
 \item{total.inertia}{The sum of inertia}
 \item{adj.inertia}{A matrix with all active dimensions, adjusted and unadjusted inertias. See \link{variance}}
 \item{freq.mod}{Frequencies for the active modalities. See \link{add.to.label}}
 \item{freq.sup}{Frequencies for the supplementary modalities. See \link{add.to.label}}
 \item{ctr.mod}{A matrix with the contribution values of the active modalities per dimension. See \link{contribution}}
 \item{ctr.ind}{A matrix with the contribution values of the individuals per dimension.}
 \item{cor.mod}{The correlation or quality of each modality per dimension.}
 \item{cor.ind}{The correlation or quality of each individual per dimension.}
 \item{mass.mod}{The mass of each modality}
 \item{coord.mod}{A matrix with the principal coordinates of each active modality per dimension.}
 \item{coord.ind}{A matrix with the principal coordinates of each individual per dimension.}
 \item{coord.sup}{A matrix with the principal coordinates of each supplementary modality per dimension.}
 \item{names.mod}{The names of the active modalities}
 \item{labels.mod}{The shorter labels of the active modalities}
 \item{names.ind}{The names of the individuals}
 \item{names.sup}{The names of the supplementary modalities}
 \item{names.passive}{The names of the passive modalities}
 \item{modal}{A matrix with the number of modalities per variable and their location}
 \item{variable}{A character vector with the name of the variable of the active modalities}
 \item{Rosenlund.tresh}{A numeric vector with the contribution values adjusted with the Rosenlund threshold, see:  see p 92 in: Rosenlund, Lennart. Exploring the City with Bourdieu: Applying Pierre Bourdieu’s Theories and Methods to Study the Community. Saarbrücken: VDM Verlag Dr. Müller, 2009.}
 \item{t.test.sup}{A matrix with a the student t-test of the coordinates of the supplementary variables}
 \item{Share.of.var}{A matrix the share of variance for each variable}
}
\description{
Specific Multiple Correspondence Analysis
}
\examples{
# Loads the "taste" dataset included in this package
data(taste)
# Create a data frame of factors containing all the active variables 
taste          <- taste[which(taste$Isup == 'Active'), ]

attach(taste)
active         <- data.frame(TV, Film, Art, Eat)
sup            <- data.frame(Gender, Age, Income)
detach(taste)

# Runs the analysis
result         <- soc.mca(active, sup)

# Prints the results
result

# A specific multiple correspondence analysis
# options defines what words or phrases that are looked for in the labels of the active modalities.
options(passive = c("Film: CostumeDrama", "TV: Tv-Sport"))
soc.mca(active, sup)
options(passive = NULL)
}
\references{
Le Roux, B., og H. Rouanet. 2010. Multiple correspondence analysis. Thousand Oaks: Sage.
}
\seealso{
\link{soc.csa}, \link{contribution}
}
\author{
Anton Grau Larsen

Jacob Lunding

Stefan Bastholm Andrade

Christoph Ellersgaard
}
