% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_age.R
\name{pop_age}
\alias{pop_age}
\title{Change age groups in population data}
\usage{
pop_age(
  pop,
  age_limits = NULL,
  pop_age_column = "lower.age.limit",
  pop_column = "population",
  ...,
  age.limits = deprecated(),
  pop.age.column = deprecated(),
  pop.column = deprecated()
)
}
\arguments{
\item{pop}{a data frame with columns indicating lower age limits and population sizes (see 'pop_age_column' and 'pop_column')}

\item{age_limits}{lower age limits of age groups to extract; if NULL
(default), the population data is returned unchanged}

\item{pop_age_column}{column in the 'pop' data frame indicating the lower age group limit}

\item{pop_column}{column in the 'pop' data frame indicating the population size}

\item{...}{ignored}

\item{age.limits, pop.age.column, pop.column}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use the underscore versions (e.g., \code{age_limits}) instead.}
}
\value{
data frame of age-specific population data
}
\description{
This changes population data to have age groups with the given age_limits, extrapolating linearly between age groups (if more are requested than available) and summing populations (if fewer are requested than available)
}
\examples{
ages_it_2015 <- wpp_age("Italy", 2015)

# Modify the age data.frame to get age groups of 10 years instead of 5
pop_age(ages_it_2015, age_limits = seq(0, 100, by = 10))

# The function will also automatically interpolate if necessary
pop_age(ages_it_2015, age_limits = c(0, 18, 40, 65))

}
