% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexcel2.R
\name{L2Scores}
\alias{L2Scores}
\alias{L2Ranking}
\alias{lexcel2Scores}
\alias{lexcel2Ranking}
\title{L2 Ranking}
\usage{
L2Scores(powerRelation, elements = powerRelation$elements)

L2Ranking(powerRelation)

lexcel2Scores(powerRelation, elements = powerRelation$elements)

lexcel2Ranking(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{elements}{Vector of elements of which to calculate their scores.
By default, the scores of all elements in \code{powerRelation$elements} are considered.}
}
\value{
Score function returns a list of type \code{L2Scores} and length of \code{powerRelation$elements}
(unless parameter \code{elements} is specified).
Each index contains a matrix with \code{length(powerRelation$eqs)} columns and \code{1 + length(powerRelation$elements)} rows.

Ranking function returns corresponding \code{\link{SocialRanking}} object.
}
\description{
Calculate the \eqn{L^{(2)}}{L^(2)} scores.
}
\details{
Let \eqn{N}{N} be a set of elements, \eqn{\succsim \in \mathcal{T}(\mathcal{P})}{>= in T(P)} a power relation,
and \eqn{\Sigma_1 \succ \Sigma_2 \succ \dots \succ \Sigma_m}{E_1 > E_2 > ... > E_m} its corresponding quotient order.

For an element \eqn{i \in N}{i in N}, construct a matrix \eqn{M^\succsim_i}{M^(>=)_i} with \eqn{m}{m} columns and \eqn{|N|}{|N|} rows.
Whereas each column \eqn{q}{q} represents an equivalence class, each row \eqn{p}{p} corresponds to the coalition size.

\deqn{(M^\succsim_i)_{p,q} = |\lbrace S \in \Sigma_q: |S| = p \text{ and } i \in S\rbrace|}{(M^(>=)_i)_pq = |\{S in E_q: |S| = p and i in S\}}

Given two elements \eqn{i, j \in N}{i, j in N}, \eqn{L^{(2)}}{L^(2)} then ranks
\eqn{i}{i} \emph{strictly above} \eqn{j}{j} if there is some row
\eqn{p^0 \in \lbrace 1, \dots, |N| \rbrace}{p^0 in \{1, ..., |N|\}} and column
\eqn{q^0 \in \lbrace 1, \dots, m \rbrace}{q^0 in \{1, ..., m\}} such that
\enumerate{
\item \eqn{\sum_{p = 1}^{|N|} (M^\succsim_i)_{p,q} = \sum_{p = 1}^{|N|} (M^\succsim_j)_{p,q}\text{ for all } q < q^0}{sum_(p=1)^(|N|) (M^(>=)_i)_(p,q) = sum_(p=1)^(|N|) (M^(>=)_j)_(p,q) for all q < q^0},
\item \eqn{\begin{cases}
\text{(i)\hphantom{i} either } & \sum_{p=1}^{|N|} (M^\succsim_i)_{p,q^0} > \sum_{p=1}^{|N|} (M^\succsim_j)_{p,q^0}\\[5pt]
\text{(ii) or } & (M^\succsim_i)_{p^0,q^0} > (M^\succsim_j)_{p^0,q^0} \text{ and } (M^\succsim_i)_{p,q^0} = (M^\succsim_j)_{p,q^0} \text{ for all } p < p^0
\end{cases}}{either (i) the sum of the values in column q^0 in M^(>=)_i is greater than in M^(>=)_j, or (ii), (M^(>=)_i)_(p^0,q^0) > (M^(>=)_j)_(p^0,q^0) and every value above p^0 is the same.}
}

Note that the conditions are very similar to \code{\link[=L1Ranking]{L1Ranking()}}, with the difference that condition 3.(i)
also ranks an element over another if they simply appear more often in an equivalence class, regardless of coalition size.
This implies that a row \eqn{p^0}{p^0} for condition 3.(ii) to be satisfied may not have to exist.
}
\section{Example}{


Let \eqn{N = \lbrace 1, 2, 3, 4 \rbrace}{N = \{1, 2, 3, 4\}} and \eqn{\succsim: (123 \sim 12 \sim 13 \sim 14 \sim 2 \sim 4) \succ S}{>=: (123 ~ 12 ~ 13 ~ 14 ~ 2 ~ 4) > S},
where \eqn{S}{S} is every other coalition not present in the first equivalence class.
From this, we get the following four matrices:

\deqn{
M^\succsim_1 = \begin{bmatrix}
0 & 1\\
3 & 0\\
1 & 2\\
0 & 1
\end{bmatrix}
M^\succsim_2 = \begin{bmatrix}
1 & 0\\
1 & 2\\
1 & 2\\
0 & 1
\end{bmatrix}
M^\succsim_3 = \begin{bmatrix}
0 & 1\\
1 & 2\\
1 & 2\\
0 & 1
\end{bmatrix}
M^\succsim_4 = \begin{bmatrix}
1 & 0\\
1 & 2\\
0 & 3\\
0 & 1
\end{bmatrix}
}{
M^(>=)_1 = matrix(c(0,3,1,0,1,0,2,1),nrow=4)\\
M^(>=)_2 = matrix(c(1,1,1,0,0,2,2,1),nrow=4)\\
M^(>=)_3 = matrix(c(0,1,1,0,1,2,2,1),nrow=4)\\
M^(>=)_4 = matrix(c(1,1,0,0,0,2,3,1),nrow=4)
}

For the sums in column 1, we get

\deqn{\begin{aligned}\sum_{p=1}^{4} (M^\succsim_1)_{p,1} &= 4,\\\sum_{p=1}^{4} (M^\succsim_2)_{p,1} &= 3,\\\sum_{p=1}^{4} (M^\succsim_3)_{p,1} = \sum_{p=1}^{4} (M^\succsim_4)_{p,1} &= 2\end{aligned}.}{4 for M^(>=)_1, 3 for M^(>=)_2, and 2 for M^(>=)_3 and M^(>=)_4.}

This immediately puts \eqn{1}{1} above all other elements and \eqn{2}{2} above \eqn{3}{3} and \eqn{4}{4} according to the \eqn{L^{(2)}}{L^(2)}.
\eqn{L^{(1)}}{L^(1)} would in this case prefer \eqn{2}{2} over \eqn{1}{1}, simply because \eqn{2}{2} appears once in a coalition of size 1 and \eqn{1}{1} doesn't.

Since the column sum for \eqn{3}{3} and \eqn{4}{4} is the same, we can next evaluate if the individual row values are also the same.
Here, since \eqn{(M^\succsim_4)_{1,1} > (M^\succsim_3)_{1,1}}, this gives an edge of element \eqn{4}{4} over \eqn{3}{3}.

Note that, if the column was identical for \eqn{3}{3} and \eqn{4}{4}, we would go to the next column and repeat the process.
Elements are only then considered indifferent from each other, if the entire matrix is identical between the two.
}

\section{Alterations}{


The matrices as described above and in \insertRef{beal2022lexicographic}{socialranking} can be investigated with the \code{\link[=L1Scores]{L1Scores()}} function.

For less complexity, another row is prepended to the matrix showing the sum of each column.
Through this, a simple \eqn{L^{(1)}}{L^(1)} comparison can be applied.
}

\section{Aliases}{


For better discoverability, \code{lexcel2Scores()} and \code{lexcel2Ranking()} serve as aliases for \code{L2Scores()} and \code{L2Ranking()}, respectively.
}

\examples{
pr <- as.PowerRelation("123 ~ 12 ~ 13 ~ 14 ~ 2 ~ 4")
pr <- appendMissingCoalitions(pr)
scores <- L2Scores(pr)
scores$`1`
#      [,1] [,2]
# [1,]    0    1
# [2,]    3    0
# [3,]    1    2
# [3,]    0    1

L2Ranking(pr)
# 1 > 2 > 4 > 3

L1Ranking(pr)
# 2 > 4 > 1 > 3

}
\references{
\insertRef{2021Lexcel}{socialranking}
}
\seealso{
Other ranking solution functions: 
\code{\link{L1Scores}()},
\code{\link{LPSScores}()},
\code{\link{LPScores}()},
\code{\link{copelandScores}()},
\code{\link{cumulativeScores}()},
\code{\link{kramerSimpsonScores}()},
\code{\link{lexcelScores}()},
\code{\link{ordinalBanzhafScores}()}
}
\concept{ranking solution functions}
