#' Work with documents in your CouchDB's.
#'
#' @name documents
#' @details If you are writing a complicated javascript function, better to do
#' that in the Futon CouchDB interface or otherwise.
#'
#' There are the following functions for working with documents:
#'
#' - `doc_create` - Create a document, with or without an ID
#' - `doc_update` - Update a document
#' - `doc_get` - Get a document
#' - `doc_delete` - Delete a document
#' - `doc_head` - Get headers for a document
#' - `doc_attach_create` - Attach something to a document
#' - `doc_attach_info` - Get info on an attachment
#' - `doc_attach_get` - Fetch an attachment
#' - `doc_attach_delete` - Delete an attachment
#' - `db_alldocs` - Get all documents
#' - `db_revisions` - Get revisions for a document
#'
NULL
