% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cushion.R
\name{Cushion}
\alias{Cushion}
\title{sofa connection client}
\value{
An object of class \code{Cushion}, with variables accessible for
host, port, path, transport, user, pwd, and headers. Functions are callable
to get headers, and to make the base url sent with all requests.
}
\description{
sofa connection client

sofa connection client
}
\section{CouchDB versions}{

\pkg{sofa} was built assuming CouchDB version 2 or greater. Some
functionality of this package will work with versions < 2, while
some may not (mango queries, see \code{\link[=db_query]{db_query()}}). I don't
plan to support older CouchDB versions per se.
}

\examples{
\dontrun{
# Create a CouchDB connection client
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

## metadata
x$host
x$path
x$port
x$type

## ping the CouchDB server
x$ping()

## get CouchDB version
x$version()

# create database
if (!"stuff" \%in\% db_list(x)) {
  db_create(x, "stuff")
}

# add documents to a database
if (!"sofadb" \%in\% db_list(x)) {
  db_create(x, "sofadb")
}
doc1 <- '{"name": "drink", "beer": "IPA", "score": 5}'
doc_create(x, dbname="sofadb", docid="abeer", doc1)

# bulk create
if (!"mymtcars" \%in\% db_list(x)) {
  db_create(x, "mymtcars")
}
db_bulk_create(x, dbname="mymtcars", doc = mtcars)
db_list(x)

## database info
db_info(x, "mymtcars")

## list dbs
db_list(x)

## all docs
db_alldocs(x, "mymtcars", limit = 3)

## changes
db_changes(x, "mymtcars")

# With auth
# x <- Cushion$new(user = 'sckott', pwd = 'sckott')

# Using Cloudant
# z <- Cushion$new(host = "ropensci.cloudant.com", transport = 'https', port = NULL,
#   user = 'ropensci', pwd = Sys.getenv('CLOUDANT_PWD'))
# z
# db_list(z)
# db_create(z, "stuff2")
# db_info(z, "stuff2")
# db_alldocs(z, "foobar")
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{host}}{(character) host}

\item{\code{port}}{(integer) port}

\item{\code{path}}{(character) url path, if any}

\item{\code{transport}}{(character) transport schema, (http|https)}

\item{\code{user}}{(character) username}

\item{\code{pwd}}{(character) password}

\item{\code{headers}}{(list) named list of headers}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Cushion$new()}}
\item \href{#method-print}{\code{Cushion$print()}}
\item \href{#method-ping}{\code{Cushion$ping()}}
\item \href{#method-make_url}{\code{Cushion$make_url()}}
\item \href{#method-get_headers}{\code{Cushion$get_headers()}}
\item \href{#method-get_auth}{\code{Cushion$get_auth()}}
\item \href{#method-version}{\code{Cushion$version()}}
\item \href{#method-clone}{\code{Cushion$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Cushion} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cushion$new(host, port, path, transport, user, pwd, headers)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{(character) A base URL (without the transport), e.g.,
\code{localhost}, \verb{127.0.0.1}, or \code{foobar.cloudant.com}}

\item{\code{port}}{(numeric) Port. Remember that if you don't want a port set,
set this parameter to \code{NULL}. Default: \code{5984}}

\item{\code{path}}{(character) context path that is appended to the end of
the url. e.g., \code{bar} in \verb{http://foo.com/bar}. Default: \code{NULL},
ignored}

\item{\code{transport}}{(character) http or https. Default: http}

\item{\code{user, pwd}}{(character) user name, and password. these are used in all
requests. if absent, they are not passed to requests}

\item{\code{headers}}{A named list of headers. These headers are used in all
requests. To use headers in individual requests and not others, pass
in headers via \code{...} in a function call.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Cushion} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method for \code{Cushion}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cushion$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ping"></a>}}
\if{latex}{\out{\hypertarget{method-ping}{}}}
\subsection{Method \code{ping()}}{
Ping the CouchDB server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cushion$ping(as = "list", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{as}}{(character) One of list (default) or json}

\item{\code{...}}{curl options passed to \link[crul:verb-GET]{crul::verb-GET}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-make_url"></a>}}
\if{latex}{\out{\hypertarget{method-make_url}{}}}
\subsection{Method \code{make_url()}}{
Construct full base URL from the pieces in the
connection object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cushion$make_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_headers"></a>}}
\if{latex}{\out{\hypertarget{method-get_headers}{}}}
\subsection{Method \code{get_headers()}}{
Get list of headers that will be sent with
each request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cushion$get_headers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_auth"></a>}}
\if{latex}{\out{\hypertarget{method-get_auth}{}}}
\subsection{Method \code{get_auth()}}{
Get list of auth values, user and pwd
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cushion$get_auth()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-version"></a>}}
\if{latex}{\out{\hypertarget{method-version}{}}}
\subsection{Method \code{version()}}{
Get the CouchDB version as a numeric
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cushion$version()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Cushion$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
