% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilDB_user_dir.R
\name{soilDB_user_dir}
\alias{soilDB_user_dir}
\title{Get soilDB User Directory Path}
\usage{
soilDB_user_dir(
  which = c("data", "config", "cache"),
  ...,
  create = TRUE,
  remove = FALSE,
  fsep = .Platform$file.sep,
  mustWork = NA
)
}
\arguments{
\item{which}{\emph{character}. One of: \code{"data"}, \code{"config"}, or \code{"cache"}. Passed
to \code{tools::R_user_dir()}.}

\item{...}{\emph{character}. Sub-directories. Additional arguments are passed to
\code{file.path()}}

\item{create}{\emph{logical}. When \code{TRUE} (default) the directory path is created
(recursively).}

\item{remove}{\emph{logical}. When \code{TRUE} the contents of the folder(s) are
deleted (recursively). Default: \code{FALSE}.}

\item{fsep}{\emph{character}. File path separator. Passed to \code{file.path()} and
\code{normalizePath()}. Default: \code{.Platform$file.sep}}

\item{mustWork}{\emph{logical}. Throw error if path cannot be normalized; passed
to \code{normalizePath()}. Default \code{NA} generates a warning.}
}
\value{
\emph{character}. File paths within specified soilDB user directory. When
\code{remove=TRUE} result is \code{NULL}.
}
\description{
Wrapper around \code{tools::R_user_dir()} for soilDB-specific file
storage in a platform-specific, user-level directory. Requires R >= 4.0.

These directories can be used for storing assets used as input to other
soilDB functions, or for caching results to allow for offline use or fewer
repeated requests to remote sources.

Use argument \code{remove=TRUE} to delete files stored in the specified
directories.
}
\details{
If the directory path does not exist it is created (recursively)
when \code{create=TRUE}. Output paths are normalized using
\code{normalizePath()} and the specified path separator (\code{fsep}).
}
\examples{

soilDB_user_dir("data", c("dataset1", "dataset2"), "source", create = FALSE)

}
\author{
Andrew Gene Brown
}
