% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sorocs.R
\name{sorocs}
\alias{sorocs}
\title{A Bayesian Semiparametric Dirichlet Process Mixtures to Estimate Correlated ROC Surfaces with Stochastic Order Constraints}
\usage{
sorocs(
  nsim = 4,
  nburn = 2,
  Yvariable1,
  Yvariable2,
  gridY = seq(0, 5, by = 0.05),
  Xvariable1,
  Xvariable2,
  gam0 = -4.6,
  gam1 = 9.2,
  lamb0 = -4.6,
  lamb1 = 9.2,
  H = 30,
  L = 30,
  alpha1 = 1,
  alpha2 = 1,
  alpha3 = 1,
  lambda1 = 1,
  lambda2 = 1,
  mu1 = matrix(c(0.5, 0.5), 2, 1),
  mu2 = matrix(c(1, 1), 2, 1),
  mu3 = matrix(c(3, 3), 2, 1),
  m1 = c(0, 0),
  m2 = c(0, 0),
  m3 = c(0, 0),
  A1 = 10 * diag(2),
  A2 = 10 * diag(2),
  A3 = 10 * diag(2),
  Sig1 = matrix(c(1, 0.5, 0.5, 1), 2, 2),
  Sig2 = matrix(c(1, 0.5, 0.5, 1), 2, 2),
  Sig3 = matrix(c(1, 0.5, 0.5, 1), 2, 2),
  nu = 6,
  C0 = 10 * diag(2),
  a1 = 2,
  a2 = 2,
  b1 = 0.1,
  b2 = 0.1
)
}
\arguments{
\item{nsim}{Number of simulations}

\item{nburn}{Burn in number}

\item{Yvariable1}{Dependent variable at setting 1}

\item{Yvariable2}{Dependent variable at setting 2}

\item{gridY}{a regular sequence spanning the range of Y variable}

\item{Xvariable1}{independent variable at setting 1}

\item{Xvariable2}{independent variable at setting 2}

\item{gam0}{Initial value for the test score distributions (e.g., a priori information between different disease populations for a single test or between multiple correlated tests)}

\item{gam1}{Initial value for the test score distributions}

\item{lamb0}{Initial value forthe test score distributions}

\item{lamb1}{Initial value for the test score distributions}

\item{H}{trucation level number for Dirichlet process prior trucation approximation}

\item{L}{trucation level number for Dirichlet process prior trucation approximation}

\item{alpha1}{fixed values of the precision parameters of the Dirichlet process}

\item{alpha2}{fixed values of the precision parameters of the Dirichlet process}

\item{alpha3}{fixed values of the precision parameters of the Dirichlet process}

\item{lambda1}{fixed values of the precision parameters of the Dirichlet process}

\item{lambda2}{fixed values of the precision parameters of the Dirichlet process}

\item{mu1}{fixed values of the bivariate normal parameters of the Dirichlet process}

\item{mu2}{fixed values of the bivariate normal parameters of the Dirichlet process}

\item{mu3}{fixed values of the bivariate normal parameters of the Dirichlet process}

\item{m1}{fixed values of the bivariate normal parameters of the Dirichlet process}

\item{m2}{fixed values of the bivariate normal parameters of the Dirichlet process}

\item{m3}{fixed values of the bivariate normal parameters of the Dirichlet process}

\item{A1}{Initial values of the bivariate normal parameters of the Dirichlet process}

\item{A2}{Initial values of the bivariate normal parameters of the Dirichlet process}

\item{A3}{Initial values of the bivariate normal parameters of the Dirichlet process}

\item{Sig1}{Initial values of the inverse Wishart distribution parameters of the Dirichlet process}

\item{Sig2}{Initial values of the inverse Wishart distribution parameters of the Dirichlet process}

\item{Sig3}{Initial values of the inverse Wishart distribution parameters of the Dirichlet process}

\item{nu}{Initial values of the inverse Wishart distribution parameters of the Dirichlet process}

\item{C0}{Initial values of the inverse Wishart distribution parameters of the Dirichlet process}

\item{a1}{Initial shape values of the inverse-gamma base distributions for the Dirichlet process}

\item{a2}{Initial shape values of the inverse-gamma base distributions for the Dirichlet process}

\item{b1}{Initial scale values of the inverse-gamma base distributions for the Dirichlet process}

\item{b2}{Initial scale values of the inverse-gamma base distributions for the Dirichlet process}
}
\value{
A list of posterior estimates
}
\description{
A Bayesian nonparametric Dirichlet process mixtures to estimate the receiver operating characteristic (ROC) 
surfaces and the associated volume under the surface (VUS), a summary measure similar to the area under the 
curve measure for ROC curves. To model distributions flexibly, including their skewness and multi-modality
characteristics a Bayesian nonparametric Dirichlet process mixtures was used. Between-setting correlations is handled
by dependent Dirichlet process mixtures that have bivariate distributions with nonzero
correlations as their bases. To  accommodate ordering constraints, the stochastic ordering in the
context of mixture distributions was adopted.
}
\examples{
library(MASS)
library(MCMCpack)
library(mvtnorm)
data(asrm)
Y1 <- asrm$logREscoremean2[1:10]
Y2 <- asrm$logREscoremean1[1:10]
X1 <-asrm$TN12[1:20]/asrm$JN12[1:10]
X2 <-asrm$TNN12[1:20]/asrm$JNN12[1:10]
try1 <- sorocs:::sorocs( H = 12, L = 12, Yvariable1 =Y1, Yvariable2= Y2,
                         gridY=seq(0,5,by=1), Xvariable1= X1, Xvariable2 =X2)
}
\references{
Zhen Chen, Beom Seuk Hwang. (2018)
\emph{A Bayesian semiparametric approach to correlated ROC surfaces with stochastic order constraints}.
Biometrics, 75, 539-550. \url{https://doi.org/10.1111/biom.12997}
}
\keyword{Dirichlet}
\keyword{mixtures}
\keyword{process}
