% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_irf.R
\name{rvar_irf}
\alias{rvar_irf}
\title{Estimate regime-dependent impulse response functions}
\usage{
rvar_irf(
  rvar,
  horizon = 10,
  CI = c(0.1, 0.9),
  bootstrap.type = "auto",
  bootstrap.num = 100,
  bootstrap.parallel = FALSE,
  bootstrap.cores = -1
)
}
\arguments{
\item{rvar}{RVAR output}

\item{horizon}{int: number of periods}

\item{CI}{numeric vector: c(lower ci bound, upper ci bound)}

\item{bootstrap.type}{string: bootstrapping technique to use ('auto', 'standard', or 'wild'); if auto then wild is used for IV or IV-short, else standard is used}

\item{bootstrap.num}{int: number of bootstraps}

\item{bootstrap.parallel}{boolean: create IRF draws in parallel}

\item{bootstrap.cores}{int: number of cores to use in parallel processing; -1 detects and uses half the available cores}
}
\value{
list of regimes, each with data.frame of columns \code{target}, \code{shock}, \code{horizon}, \code{response.lower}, \code{response}, \code{response.upper}
}
\description{
Estimate regime-dependent impulse response functions
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)
 Data = dplyr::mutate(Data, reg = dplyr::if_else(AA > median(AA), 1, 0))

 # estimate VAR
  rvar =
    sovereign::RVAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      regime.method = 'rf',
      regime.n = 2,
      lag.ic = 'BIC',
      lag.max = 4)

 # impulse response functions
 rvar.irf = sovereign::rvar_irf(rvar)

 # forecast error variance decomposition
 rvar.fevd = sovereign::rvar_fevd(rvar)

 # historical shock decomposition
 rvar.hd = sovereign::rvar_hd(rvar)

}

}
\seealso{
\code{\link[=VAR]{VAR()}}

\code{\link[=var_irf]{var_irf()}}

\code{\link[=var_fevd]{var_fevd()}}

\code{\link[=RVAR]{RVAR()}}

\code{\link[=rvar_irf]{rvar_irf()}}

\code{\link[=rvar_fevd]{rvar_fevd()}}
}
