/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import sparklyr.DaysSinceEpoch;
import sparklyr.Logical;
import sparklyr.Numeric;

public final class Serializer$ {
    public static Serializer$ MODULE$;
    private final long kMsPerDay;

    static {
        new Serializer$();
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    public byte[] readBytes(DataInputStream in) {
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        BoxedUnit bytesRead = BoxedUnit.UNIT;
        return out;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        if (bytes[len - 1] != 0) {
            throw new IllegalArgumentException("length and stream do not match");
        }
        String str = new String((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).dropRight(1), StandardCharsets.UTF_8);
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        int intVal = in.readInt();
        return intVal != 0;
    }

    public Date readDate(DataInputStream in) {
        int n = this.readInt(in);
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        return new Date(Predef$.MODULE$.Long2long(Long.valueOf(n)) * this.kMsPerDay);
    }

    public Timestamp readTime(DataInputStream in) {
        double seconds = in.readDouble();
        long sec = (long)Math.floor(seconds);
        Timestamp t = new Timestamp(sec * 1000L);
        t.setNanos((int)((seconds - (double)sec) * 1.0E9));
        return t;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        return (byte[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$1 -> Serializer$.MODULE$.readBytes(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        return (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$2 -> MODULE$.readInt(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$3 -> MODULE$.readDouble(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        return (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> MODULE$.readBoolean(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        return (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$5 -> Serializer$.MODULE$.readString(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Date[] readDateArr(DataInputStream in) {
        int len = this.readInt(in);
        return (Date[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$6 -> Serializer$.MODULE$.readDate(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Date.class));
    }

    public Timestamp[] readTimeArr(DataInputStream in) {
        int len = this.readInt(in);
        return (Timestamp[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$7 -> Serializer$.MODULE$.readTime(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        String string = typeStr;
        if ("void".equals(string)) {
            dos.writeByte(110);
            return;
        }
        if ("character".equals(string)) {
            dos.writeByte(99);
            return;
        }
        if ("double".equals(string)) {
            dos.writeByte(100);
            return;
        }
        if ("integer".equals(string)) {
            dos.writeByte(105);
            return;
        }
        if ("logical".equals(string)) {
            dos.writeByte(98);
            return;
        }
        if ("date".equals(string)) {
            dos.writeByte(68);
            return;
        }
        if ("time".equals(string)) {
            dos.writeByte(116);
            return;
        }
        if ("raw".equals(string)) {
            dos.writeByte(114);
            return;
        }
        if ("array".equals(string)) {
            dos.writeByte(97);
            return;
        }
        if ("strarray".equals(string)) {
            dos.writeByte(102);
            return;
        }
        if ("list".equals(string)) {
            dos.writeByte(108);
            return;
        }
        if ("map".equals(string)) {
            dos.writeByte(101);
            return;
        }
        if ("jobj".equals(string)) {
            dos.writeByte(106);
            return;
        }
        if ("json".equals(string)) {
            dos.writeByte(74);
            return;
        }
        if ("sparkapplybinaryresult".equals(string)) {
            dos.writeByte(36);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(typeStr).toString());
    }

    public void writeInt(DataOutputStream out, int value) {
        out.writeInt(value);
    }

    public void writeDouble(DataOutputStream out, double value) {
        out.writeDouble(value);
    }

    public void writeNumeric(DataOutputStream out, Numeric x) {
        if (x.value().isEmpty()) {
            out.writeInt(0x7FF00000);
            out.writeInt(1954);
            return;
        }
        this.writeDouble(out, BoxesRunTime.unboxToDouble((Object)x.value().get()));
    }

    public void writeBoolean(DataOutputStream out, boolean value) {
        out.writeInt(new RichBoolean(Predef$.MODULE$.booleanWrapper(value)).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public void writeLogical(DataOutputStream out, Logical value) {
        out.writeInt(value.intValue());
    }

    public void writeDate(DataOutputStream out, Date value) {
        this.writeInt(out, value == null ? Integer.MIN_VALUE : (int)(value.getTime() / this.kMsPerDay));
    }

    public void writeDate(DataOutputStream out, DaysSinceEpoch d) {
        this.writeInt(out, BoxesRunTime.unboxToInt((Object)d.value().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MIN_VALUE)));
    }

    public double timestampToSeconds(java.util.Date value) {
        if (value == null) {
            return Double.NaN;
        }
        double seconds = (double)value.getTime() / 1000.0;
        java.util.Date date = value;
        if (date instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)date;
            return seconds + (double)timestamp.getNanos() / 1.0E9;
        }
        return seconds;
    }

    public void writeTime(DataOutputStream out, java.util.Date value) {
        out.writeDouble(this.timestampToSeconds(value));
    }

    public void writeString(DataOutputStream out, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value) {
        if (value == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(value.length);
        out.write(value);
    }

    public void writeIntArr(DataOutputStream out, int[] value) {
        this.writeType(out, "integer");
        out.writeInt(value.length);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(value)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)v -> out.writeInt(v));
    }

    public void writeDoubleArr(DataOutputStream out, double[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(value)).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> out.writeDouble(v));
    }

    public void writeNumericArr(DataOutputStream out, Numeric[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            Serializer$.MODULE$.writeNumeric(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            Serializer$.MODULE$.writeBoolean(out, BoxesRunTime.unboxToBoolean((Object)v));
            return BoxedUnit.UNIT;
        });
    }

    public void writeLogicalArr(DataOutputStream out, Logical[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            Serializer$.MODULE$.writeInt(out, v.intValue());
            return BoxedUnit.UNIT;
        });
    }

    public void writeTimestampArr(DataOutputStream out, Timestamp[] value) {
        this.writeType(out, "time");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            Serializer$.MODULE$.writeTime(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value) {
        String all = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).mkString("\u0019");
        this.writeString(out, all);
    }

    public void writeDateArr(DataOutputStream out, Date[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            Serializer$.MODULE$.writeDate(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public void writeDateArr(DataOutputStream out, DaysSinceEpoch[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            Serializer$.MODULE$.writeDate(out, v);
            return BoxedUnit.UNIT;
        });
    }

    private Serializer$() {
        MODULE$ = this;
        this.kMsPerDay = 86400000L;
    }
}

