% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda-emp-bayes.r
\name{lda_emp_bayes}
\alias{lda_emp_bayes}
\alias{lda_emp_bayes.default}
\alias{lda_emp_bayes.formula}
\alias{predict.lda_emp_bayes}
\title{The Minimum Distance Empirical Bayesian Estimator (MDEB) classifier}
\usage{
lda_emp_bayes(x, ...)

\method{lda_emp_bayes}{default}(x, y, prior = NULL, ...)

\method{lda_emp_bayes}{formula}(formula, data, prior = NULL, ...)

\method{predict}{lda_emp_bayes}(object, newdata, type = c("class", "prob", "score"), ...)
}
\arguments{
\item{x}{Matrix or data frame containing the training data. The rows are the
sample observations, and the columns are the features. Only complete data are
retained.}

\item{...}{additional arguments (not currently used).}

\item{y}{Vector of class labels for each training observation. Only complete
data are retained.}

\item{prior}{Vector with prior probabilities for each class. If NULL
(default), then equal probabilities are used. See details.}

\item{formula}{A formula of the form \code{groups ~ x1 + x2 + ...} That is,
the response is the grouping factor and the right hand side specifies the
(non-factor) discriminators.}

\item{data}{data frame from which variables specified in \code{formula} are
preferentially to be taken.}

\item{object}{Fitted model object}

\item{newdata}{Matrix or data frame of observations to predict. Each row
corresponds to a new observation.}

\item{type}{Prediction type: either \code{"class"}, \code{"prob"}, or \code{"score"}.}
}
\value{
\code{lda_emp_bayes} object that contains the trained MDEB classifier
}
\description{
Given a set of training data, this function builds the MDEB classifier from
Srivistava and Kubokawa (2007). The MDEB classifier is an adaptation of the
linear discriminant analysis (LDA) classifier that is designed for
small-sample, high-dimensional data. Rather than using the standard maximum
likelihood estimator of the pooled covariance matrix, Srivastava and Kubokawa
(2007) have proposed an Empirical Bayes estimator where the eigenvalues of
the pooled sample covariance matrix are shrunken towards the identity matrix:
the shrinkage constant has a closed form and is quick to calculate.

The MDEB classifier from Srivistava and Kubokawa (2007) is an adaptation of the
linear discriminant analysis (LDA) classifier that is designed for
small-sample, high-dimensional data. Rather than using the standard maximum
likelihood estimator of the pooled covariance matrix, Srivastava and Kubokawa
(2007) have proposed an Empirical Bayes estimator where the eigenvalues of
the pooled sample covariance matrix are shrunken towards the identity matrix:
the shrinkage constant has a closed form and is quick to calculate
}
\details{
The matrix of training observations are given in \code{x}. The rows of \code{x}
contain the sample observations, and the columns contain the features for each
training observation.

The vector of class labels given in \code{y} are coerced to a \code{factor}.
The length of \code{y} should match the number of rows in \code{x}.

An error is thrown if a given class has less than 2 observations because the
variance for each feature within a class cannot be estimated with less than 2
observations.

The vector, \code{prior}, contains the \emph{a priori} class membership for
each class. If \code{prior} is NULL (default), the class membership
probabilities are estimated as the sample proportion of observations belonging
to each class. Otherwise, \code{prior} should be a vector with the same length
as the number of classes in \code{y}. The \code{prior} probabilities should be
nonnegative and sum to one.
}
\examples{
library(modeldata)
data(penguins)
pred_rows <- seq(1, 344, by = 20)
penguins <- penguins[, c("species", "body_mass_g", "flipper_length_mm")]
mdeb_out <- lda_emp_bayes(species ~ ., data = penguins[-pred_rows, ])
predicted <- predict(mdeb_out, penguins[pred_rows, -1], type = "class")

mdeb_out2 <- lda_emp_bayes(x = penguins[-pred_rows, -1], y = penguins$species[-pred_rows])
predicted2 <- predict(mdeb_out2, penguins[pred_rows, -1], type = "class")
all.equal(predicted, predicted2)
}
\references{
Srivastava, M. and Kubokawa, T. (2007). "Comparison of
Discrimination Methods for High Dimensional Data," Journal of the Japanese
Statistical Association, 37, 1, 123-134.
}
