% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{methods}
\alias{methods}
\alias{wrap_empty}
\alias{wrap_separate}
\alias{predict.wrap_separate}
\alias{coef.wrap_separate}
\alias{wrap_common}
\alias{predict.wrap_common}
\alias{coef.wrap_common}
\alias{wrap_mgaussian}
\alias{predict.wrap_mgaussian}
\alias{coef.wrap_mgaussian}
\alias{wrap_spls}
\alias{predict.wrap_spls}
\alias{coef.wrap_spls}
\alias{wrap_glmtrans}
\alias{predict.wrap_glmtrans}
\alias{coef.wrap_glmtrans}
\alias{wrap_xrnet}
\alias{predict.wrap_xrnet}
\alias{coef.wrap_xrnet}
\title{Available methods}
\usage{
wrap_empty(x, y, family, alpha = 1)

wrap_separate(x, y, family, alpha = 1, lambda = NULL)

\method{predict}{wrap_separate}(object, newx, ...)

\method{coef}{wrap_separate}(object, ...)

wrap_common(x, y, family, alpha = 1)

\method{predict}{wrap_common}(object, newx, ...)

\method{coef}{wrap_common}(object, ...)

wrap_mgaussian(x, y, family = "gaussian", alpha = 1)

\method{predict}{wrap_mgaussian}(object, newx, ...)

\method{coef}{wrap_mgaussian}(object, ...)

wrap_spls(x, y, family = "gaussian", alpha = 1, nfolds = 10)

\method{predict}{wrap_spls}(object, newx, ...)

\method{coef}{wrap_spls}(object, ...)

wrap_glmtrans(x, y, family = "gaussian", alpha = 1)

\method{predict}{wrap_glmtrans}(object, newx, ...)

\method{coef}{wrap_glmtrans}(object, ...)

wrap_xrnet(
  x,
  y,
  alpha.init = 0.95,
  alpha = 1,
  nfolds = 10,
  family = "gaussian"
)

\method{predict}{wrap_xrnet}(object, newx, ...)

\method{coef}{wrap_xrnet}(object, ...)
}
\arguments{
\item{x}{feature matrix (multi-task learning)
or list of \eqn{q} feature matrices (transfer learning)}

\item{y}{response matrix (multi-task learning)
or list of \eqn{q} response vectors (transfer learning)}

\item{family}{character vector with 1 or \eqn{q} entries,
possible values are \code{"gaussian"} and sometimes \code{"binomial"} or other}

\item{alpha}{elastic net mixing parameter:
number between 0 and 1}

\item{lambda}{sequence of regularisation parameters}

\item{object}{output from multi-task learning or transfer learning method}

\item{newx}{feature matrix (MTL) or list of feature matrices (TL)
of testing samples}

\item{...}{(not applicable)}

\item{nfolds}{number of cross-validation folds: positive integer}

\item{alpha.init}{elastic net mixing parameter for initial models:
number between 0 and 1}
}
\value{
The wrapper functions \code{wrap_empty}, \code{wrap_separate},
\code{wrap_common}, \code{wrap_mgaussian}, \code{wrap_spls},
\code{wrap_glmtrans}, and \code{wrap_xrnet} return fitted models,
and the generic functions \code{coef} and \code{predict}
return coefficients or predicted values in a standardised format.
}
\description{
Wrapper functions of available methods for related problems.
}
\section{Functions}{
\itemize{
\item \code{wrap_empty()}: intercept-only model (MTL and TL)

\item \code{wrap_separate()}: separate model for each problem (MTL and TL)

\item \code{wrap_common()}: common model for all problems (TL)

\item \code{wrap_mgaussian()}: multivariate Gaussian regression (MTL)

\item \code{wrap_spls()}: sparse partial least squares (MTL)

\item \code{wrap_glmtrans()}: transfer generalised linear model (TL)

\item \code{wrap_xrnet()}: hierarchical regression (TL)

}}
\examples{
#--- multi-task learning ---
n_train <- 100
n_test <- 10
p <- 50
q <- 3
family <- "gaussian"
x <- matrix(data=rnorm(n=n_train*p),nrow=n_train,ncol=p)
newx <- matrix(data=rnorm(n=n_test*p),nrow=n_test,ncol=p)
y <- matrix(data=rnorm(n_train*q),nrow=n_train,ncol=q)
object <- wrap_empty(x=x,y=y,family=family)
model <- "empty" # try "empty", "separate", "mgaussian" or "spls"
if(model=="empty"){
  object <- wrap_empty(x=x,y=y,family=family)
} else if(model=="separate"){
  object <- wrap_separate(x=x,y=y,family=family)
} else if(model=="mgaussian"){
  object <- wrap_mgaussian(x=x,y=y,family=family)
} else if(model=="spls"){
  object <- wrap_spls(x=x,y=y,family=family)
}
coef(object)
predict(object,newx=newx)

#--- transfer learning ---
n_train <- c(100,50)
n_test <- c(10,10)
p <- 50
x <- lapply(X=n_train,function(n) matrix(data=stats::rnorm(n*p),nrow=n,ncol=p))
newx <- lapply(X=n_test,function(n) matrix(data=stats::rnorm(n*p),nrow=n,ncol=p))
y <- lapply(X=n_train,function(n) stats::rnorm(n))
family <- "gaussian"
model <- "empty" # try "empty", "separate", "common", "glmtrans", or "xrnet"
if(model=="empty"){
 object <- wrap_empty(x=x,y=y,family=family)
} else if(model=="separate"){
 object <- wrap_separate(x=x,y=y,family=family)
} else if(model=="common"){
 object <- wrap_common(x=x,y=y,family=family)
} else if(model=="glmtrans"){
 object <- wrap_glmtrans(x=x,y=y,family=family)
} else if(model=="xrnet"){
 object <- wrap_xrnet(x=x,y=y,family=family)
}
coef(object)
predict(object,newx=newx)

}
\references{
Noah Simon, Jerome H. Friedman, and Trevor Hastie (2013). 
\emph{arXiv} (Preprint).
\doi{10.48550/arXiv.1311.6529}.
(\link[glmnet]{cv.glmnet})

Hyonho Chun and Sündüz Keleş (2010).
"Sparse Partial Least Squares Regression for Simultaneous Dimension Reduction and Variable Selection".
\emph{Journal of the Royal Statistical Society Series B: Statistical Methodology}
72(1);3–25.
\doi{10.1111/j.1467-9868.2009.00723.x}.
(\link[spls]{spls})

Ye Tian and Yang Feng (2022).
"Transfer learning under high-dimensional generalized linear models".
\emph{Journal of the American Statistical Association}
118(544):2684-2697.
\doi{10.1080/01621459.2022.2071278}.
(\link[glmtrans]{glmtrans})

Garrett M. Weaver and Juan Pablo Lewinger (2019).
"xrnet: Hierarchical Regularized Regression to Incorporate External Data".
\emph{Journal of Open Source Software}
4(44):1761.
\doi{10.21105/joss.01761}.
(\link[xrnet]{xrnet})
}
\seealso{
See original functions
\link[glmnet]{cv.glmnet} (with argument \code{family="mgaussian"})
\link[spls]{spls}, \link[glmtrans]{glmtrans}, and \link[xrnet]{xrnet}.
}
\keyword{internal}
