% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bssr.1subgroup.r
\name{bssr.1subgroup}
\alias{bssr.1subgroup}
\title{Blinded Sample Size Recalculation for a One Subgroup Design}
\source{
\code{bssr.1subgroup} uses code contributed by Marius Placzek.
}
\usage{
bssr.1subgroup(
  data,
  alpha,
  beta,
  delta,
  eps = 0.001,
  approx = c("conservative.t", "liberal.t", "normal"),
  df = c("n", "n1"),
  adjust = c("YES", "NO"),
  k = 1,
  nmax = 1000
)
}
\arguments{
\item{data}{data matrix with data from ongoing trial: see 'Details'.}

\item{alpha}{level (type I error) to which the hypothesis is tested.}

\item{beta}{type II error (power=1-beta) to which an alternative should be proven.}

\item{delta}{vector of treatment effects to be proven, c(outside subgroup, inside subgroup).}

\item{eps}{precision parameter concerning the power calculation in the iterative sample size search algorithm.}

\item{approx}{approximation method: Use a conservative multivariate t distribution ("conservative.t"), a liberal multivariate t distribution ("liberal.t") or a multivariate normal distribution ("normal") to approximate the joint distribution of the standardized test statistics.}

\item{df}{in case of a multivariate t distribution approximation, recalculate sample size with degrees of freedom depending on the size of the IPS (df=n1) or depending on the final sample size (df=n).}

\item{adjust}{adjust blinded estimators for assumed treatment effect ("YES","No").}

\item{k}{sample size allocation factor between groups: see 'Details'.}

\item{nmax}{maximum total sample size.}
}
\value{
\code{bssr.1subgroup} returns a list containing the recalculated required sample size within the control group and treatment group along with all relevant parameters. Use \code{\link{summary.bssrest}} for a structured overview.
}
\description{
Given data from an Internal Pilot Study (IPS), \code{bssr.1subgroup} reestimates the nuisance parameters, i.e. variances and prevalence, and recalculates the required sample size for proving a desired alternative when testing for an effect in the full or subpopulation. See 'Details' for more information.
}
\details{
This function performs blinded nuisance parameter reestimation in a design with a subgroup within a full population where we want to test for treatment effects between a control and a treatment group.
Then the required sample size for the control and treatment group to prove an existing
alternative \code{delta} with a specified power 1-\code{beta} when testing the global null hypothesis \eqn{H_0: \Delta_F=\Delta_S=0} to level \code{alpha} is calculated.

The data matrix \code{data} should have three columns: The first column has to be a binary variable (0=treatment group, 1=control group). The second column should also contain a binary variable giving the full population/subgroup differentiation (0=full population, 1=subpopulation). The last column contains the observations.

For sample sizes \eqn{n_C} and \eqn{n_T} of the control and treatment group, respectively, the argument \code{k} is the
sample size allocation factor, i.e. \eqn{k = n_T/n_C}.

The parameter \code{df} provides a difference to the standard sample size calculation procedure implemented in \code{\link{n.1subgroup}}.
When applying a multivariate t distribution approximation to approximate the joint distribution of the standardized test statistics it gives the opportunity to use degrees of freedom depending on the number of subjects in the IPS instead of degrees of freedom depending on the projected final sample size.
Note that this leads to better performance when dealing with extremely small subgroup sample sizes but significantly increases the calculated final sample size.
}
\examples{
#Given data from the Internal Pilot Study, reestimate the nuisance parameters and
#recalculate the required sample size to correctly reject with
#80\% probability when testing the global Nullhypothesis H_0: Delta_F=Delta_S = 0
#assuming the true effect Delta_S=1 is in the subgroup (no effect outside of the subgroup).

random<-r.1subgroup(n=50, delta=c(0,1), sigma=c(1,1.2), tau=0.4, fix.tau="YES", k=2)
reestimate<-bssr.1subgroup(data=random,alpha=0.05,beta=0.1,delta=c(0,1),eps=0.001,
approx="conservative.t",df="n1",k=2,adjust="NO")
summary(reestimate)

}
\seealso{
\code{\link{n.1subgroup}} for sample size calculation prior to the trial.
}
