% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca}
\alias{pca}
\title{Compute Principal Component Analysis}
\usage{
pca(x = NULL, colnames.prefix = "pca_factor")
}
\arguments{
\item{x}{Numeric matrix or data frame to decompose into principal components.}

\item{colnames.prefix}{Character string used as prefix for column names in the output. Default: \code{"pca_factor"}.}
}
\value{
Data frame where each column is a principal component, ordered by decreasing variance explained. Columns are named with the pattern \verb{<prefix>_<number>} (e.g., "pca_factor_1", "pca_factor_2"). The number of rows matches the number of rows in \code{x}.
}
\description{
Computes principal components from a numeric matrix or data frame with automatic scaling and zero-variance removal. Returns all principal components as a data frame. Wrapper for \code{\link[stats:prcomp]{stats::prcomp()}}.
}
\details{
This function performs Principal Component Analysis (PCA) to create uncorrelated linear combinations of the original variables. The PCA process:
\enumerate{
\item Removes columns with zero variance (constant values)
\item Scales all remaining variables to mean = 0 and standard deviation = 1
\item Computes principal components using singular value decomposition
\item Returns all principal components ordered by decreasing variance explained
}

\strong{Usage in spatial analysis:}

PCA is useful for dimension reduction when working with spatial distance matrices or multiple correlated spatial predictors. It creates orthogonal (uncorrelated) variables that capture the main patterns of variation while reducing dimensionality.

For spatial modeling with \code{\link[=rf_spatial]{rf_spatial()}}, principal components of distance matrices can serve as alternative spatial predictors to Moran's Eigenvector Maps (MEMs). Use \code{\link[=pca_multithreshold]{pca_multithreshold()}} to compute PCA across multiple distance thresholds for multi-scale spatial modeling.
}
\examples{
data(plants_distance)

# Compute principal components from distance matrix
pca_components <- pca(x = plants_distance)

# View structure
head(pca_components)
dim(pca_components)

# Check column names
colnames(pca_components)[1:5]

# Custom column prefix
pca_custom <- pca(
  x = plants_distance,
  colnames.prefix = "distance_pc"
)
colnames(pca_custom)[1:3]

}
\seealso{
\code{\link[=pca_multithreshold]{pca_multithreshold()}}, \code{\link[=mem]{mem()}}, \code{\link[stats:prcomp]{stats::prcomp()}}

Other spatial_analysis: 
\code{\link{filter_spatial_predictors}()},
\code{\link{mem}()},
\code{\link{mem_multithreshold}()},
\code{\link{moran}()},
\code{\link{moran_multithreshold}()},
\code{\link{pca_multithreshold}()},
\code{\link{rank_spatial_predictors}()},
\code{\link{residuals_diagnostics}()},
\code{\link{residuals_test}()},
\code{\link{select_spatial_predictors_recursive}()},
\code{\link{select_spatial_predictors_sequential}()}
}
\concept{spatial_analysis}
