# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Middle frame
#'
#' Average image of the series of 512 x 512 px images
#'
#' @param filename A string.
#' @param subtrahend 512 x 512 matrix to subtract.
#' @param threshold An integer (default 50000).
#' @return The 512 x 512 matrix of middle speckle image.
#' @examples
#' obj_filename <- system.file("extdata", "ads15182_550_2_frames.dat", package = "specklestar")
#' zero_matrix <- matrix(0, 512, 512)
#' mf <- middle_frame(obj_filename, subtrahend = zero_matrix)
#' @export
middle_frame <- function(filename, subtrahend, threshold = 50000L) {
    .Call('_specklestar_middle_frame', PACKAGE = 'specklestar', filename, subtrahend, threshold)
}

#' Autocorrelation function calculation
#'
#' Autocorrelation function of power spectrum
#'
#' @param ps 513 x 1024 power spectrum double matrix.
#' @return The 513 x 1024 double matrix of ACF.
#' @examples
#' obj_filename <- system.file("extdata", "ads15182_550_2_frames.dat", package = "specklestar")
#' pow_spec_diff <- speckle_ps_diff(obj_filename)
#' acf <- speckle_acf(pow_spec_diff)
#' @export
speckle_acf <- function(ps) {
    .Call('_specklestar_speckle_acf', PACKAGE = 'specklestar', ps)
}

#' Speckle Generator
#'
#' Generate model 512 x 512 x 2 (bytes) speckle image of binary star
#'
#' @param rho a separation (an arcsec).
#' @param theta a positional angle.
#' @param dm a magnitude difference.
#' @param seeing a number.
#' @param speckle_sigma a number.
#' @param wind a wind speed.
#' @return The vector of model speckle image.
#' @examples
#' speckle_vector <- speckle_generator(rho = 0.5, theta = 70,
#' dm = 0.3, seeing = 20, speckle_sigma = 1, wind = 0)
#' speckle_matrix <- matrix(speckle_vector, nrow = 512, ncol = 512)
#' @export
speckle_generator <- function(rho, theta, dm, seeing, speckle_sigma, wind) {
    .Call('_specklestar_speckle_generator', PACKAGE = 'specklestar', rho, theta, dm, seeing, speckle_sigma, wind)
}

#' Power spectrum calculation
#'
#' Power spectrum of the difference of neighboring frames
#' in the series of speckle images
#'
#' @param filename a character string with the path name to a file.
#' @param threshold an integer (default is 50000).
#' @return The 513 x 1024 double matrix of power spectrum.
#' @examples
#' obj_filename <- system.file("extdata", "ads15182_550_2_frames.dat", package = "specklestar")
#' pow_spec_diff <- speckle_ps_diff(obj_filename)
#' @export
speckle_ps_diff <- function(filename, threshold = 50000L) {
    .Call('_specklestar_speckle_ps_diff', PACKAGE = 'specklestar', filename, threshold)
}

#' Power spectrum calculation
#'
#' Power spectrum of the series of 512 x 512 speckle images
#'
#' @param filename a character string with the path name to a file.
#' @param dark 512 x 512 middle frame matrix.
#' @param flat 512 x 512 middle flat field matrix.
#' @param threshold an integer (default is 50000).
#' @return The 513 x 1024 double matrix of power spectrum.
#' @examples
#' obj_filename <- system.file("extdata", "ads15182_550_2_frames.dat", package = "specklestar")
#' midd_dark <- matrix(0, 512, 512)
#' midd_flat <- matrix(1, 512, 512)
#' pow_spec <- speckle_ps(obj_filename, dark = midd_dark, flat = midd_flat)
#' @export
speckle_ps <- function(filename, dark, flat, threshold = 50000L) {
    .Call('_specklestar_speckle_ps', PACKAGE = 'specklestar', filename, dark, flat, threshold)
}

#' Statistics of speckles
#'
#' Calculate statistics of speckles in the series of 512 x 512
#' speckle images and filter "bad" frames
#'
#' @param filename a character string with the path name to a file.
#' @param threshold an integer (default is 50000).
#' @return The list with 2 elements 'badFrames' and 'hist': \cr
#' 1 number of bad frames, \cr
#' 2 double vector of speckle statistics.
#' @examples
#' obj_filename <- system.file("extdata", "ads15182_550_2_frames.dat", package = "specklestar")
#' spec_stat <- speckle_stat(obj_filename)
#' @export
speckle_stat <- function(filename, threshold = 50000L) {
    .Call('_specklestar_speckle_stat', PACKAGE = 'specklestar', filename, threshold)
}

