% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{speckle_stat}
\alias{speckle_stat}
\title{Statistics of speckles}
\usage{
speckle_stat(filename, threshold = 50000L)
}
\arguments{
\item{filename}{a character string with the path name to a file.}

\item{threshold}{an integer (default is 50000).}
}
\value{
The list with 2 elements 'badFrames' and 'hist': \cr
1 number of bad frames, \cr
2 double vector of speckle statistics.
}
\description{
Calculate statistics of speckles in the series of 512 x 512
speckle images and filter "bad" frames
}
\examples{
obj_filename <- system.file("extdata", "ads15182_550_2_frames.dat", package = "specklestar")
spec_stat <- speckle_stat(obj_filename)
}
