% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.r
\name{plot.specr.setup}
\alias{plot.specr.setup}
\title{Plot visualization of the specification setup}
\usage{
\method{plot}{specr.setup}(x, layout = "dendrogram", circular = FALSE, ...)
}
\arguments{
\item{x}{A \code{specr.setup} object, usually resulting from calling \code{setup()}.}

\item{layout}{The type of layout to create for the garden of forking path. Defaults to "dendrogram". See \code{?ggraph} for options.}

\item{circular}{Should the layout be transformed into a radial representation. Only possible for some layouts. Defaults to FALSE.}

\item{...}{further arguments passed to or from other methods (currently ignored).}
}
\value{
A \link[ggplot2]{ggplot} object that can be customized further.
}
\description{
This function plots a visual summary of the specification setup.
It requires an object of class \code{specr.setup}, usually
the result of calling \code{setup()}.
}
\examples{
\dontrun{
specs <- setup(data = example_data,
   x = c("x1", "x2", "x3"),
   y = c("y1", "y2"),
   model = c("lm", "glm"),
   controls = "c1",
   subsets = list(group2 = unique(example_data$group2)))

plot(specs)
plot(specs, circular = TRUE)
}
}
