% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spellcheckr.R
\name{correct}
\alias{correct}
\title{correct}
\usage{
correct(wd = NULL, maxedit = 2, dictionary = NULL)
}
\arguments{
\item{wd}{Character. The word to be spell corrected.}

\item{maxedit}{Integer. The maximum number of edits allowed to reach the correct word. Max allowed is 3.}

\item{dictionary}{Character Vector of eligible words to be considered. Repeated words will get more weightage.}
}
\value{
The corrected word.
}
\description{
Correct the spelling of a given word in the english language.
}
\details{
This is based on Peter Norvig's spell correct algorithm \url{http://norvig.com/spell.py}.
But this one is modified to handle upto three edits.
}
\examples{
data(dict)
correct("scaret")
correct("beliebe")
}
\author{
Selva Prabhakaran \email{selva86@gmail.com}
}

