% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varlist.R
\name{varlist}
\alias{varlist}
\alias{vl}
\title{Generate a comprehensive summary of the variables}
\usage{
varlist(
  x,
  ...,
  values = FALSE,
  tbl = FALSE,
  include_na = FALSE,
  .raw_expr = substitute(x)
)

vl(x, ..., values = FALSE, tbl = FALSE, include_na = FALSE)
}
\arguments{
\item{x}{A data frame or a transformation of one. Must be named and identifiable.}

\item{...}{Optional tidyselect-style column selectors (e.g. \code{starts_with("var")}, \code{where(is.numeric)}, etc.).}

\item{values}{Logical. If \code{FALSE} (the default), only min/max or representative values are displayed.
If \code{TRUE}, all unique values are listed.}

\item{tbl}{Logical. If \code{FALSE} (the default), the summary is opened in the Viewer (if interactive).
If \code{TRUE}, a tibble is returned instead.}

\item{include_na}{Logical. If \code{TRUE}, missing values (\code{NA}) are included in the \code{Values} column.
Default is \code{FALSE}.}

\item{.raw_expr}{Internal. Do not use. Captures the original expression from \code{vl()} to generate an informative title. Used only for internal purposes.}
}
\value{
A tibble with one row per (selected) variable, containing the following columns:
\itemize{
\item \code{Variable}: variable names
\item \code{Label}: variable labels (if available via the \code{label} attribute)
\item \code{Values}: a summary of the variable's values, depending on the \code{values} and \code{include_na} arguments.
If \code{values = FALSE}, a compact summary (max 4 values: 3 + ... + last) is shown.
If \code{values = TRUE}, all unique non-missing values are displayed.
For labelled variables, \strong{prefixed labels} are displayed using \code{labelled::to_factor(levels = "prefixed")}.
For factors, levels are used as-is.
Missing values (\code{NA}, \code{NaN}) are optionally appended at the end (controlled via \code{include_na}).
\item \code{Class}: the class of each variable (possibly multiple, e.g. \verb{"labelled", "numeric"})
\item \code{N_distinct}: number of distinct non-missing values
\item \code{N_valid}: number of non-missing observations
\item \code{NAs}: number of missing observations
If \code{tbl = FALSE} and used interactively, the summary is displayed in the Viewer pane.
If the data frame is a transformation (e.g. \code{head(df)} or \code{df[ , 1:3]}), an asterisk (\code{*}) is appended to the name in the title (e.g. \verb{vl: df*}).
}
}
\description{
\code{varlist()} lists the variables of a data frame and extracts essential metadata, including variable names, labels, summary values, classes, number of distinct values, number of valid (non-missing) observations, and number of missing values.

\code{vl()} is a convenient shorthand for \code{varlist()} that offers identical functionality with a shorter name.
}
\details{
The function can also apply tidyselect-style variable selectors to filter columns dynamically.

If used interactively (e.g. in RStudio), the summary is displayed in the Viewer pane with a contextual title like \code{vl: iris}. If the data frame has been transformed or subsetted, the title will display an asterisk (\code{*}), e.g. \verb{vl: iris*}.

For full documentation, see \code{\link[=varlist]{varlist()}}.
}
\examples{
varlist(iris)
iris |> varlist()
iris |> varlist(starts_with("Sepal"), tbl = TRUE)
varlist(mtcars, where(is.numeric), values = TRUE, tbl = TRUE)
varlist(head(mtcars), tbl = TRUE)
varlist(mtcars, tbl = TRUE)
varlist(iris[, 1:3], tbl = TRUE)
varlist(mtcars[1:10, ], tbl = TRUE)

vl(iris)
iris |> vl()
vl(mtcars, starts_with("d"))
vl(head(iris), include_na = TRUE)
vl(iris[, 1:3], values = TRUE, tbl = TRUE)
}
