% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiral.R
\name{current_spiral}
\alias{current_spiral}
\title{Get the current spiral object}
\usage{
current_spiral()
}
\value{
A \code{spiral} object.
}
\description{
Get the current spiral object
}
\details{
The returned value is an object of \code{spiral} reference class. The following methods might be useful (assume the object is named \code{s}):
\itemize{
\item \code{s$curve()}: It returns the radius for given angles (in radians).
\item \code{s$spiral_length()}: It returns the length of the spiral (from the origin) for a given angle (in radians), thus if you want to get the length of a spiral segment,
it will be \code{s$spiral_length(theta2) - s$spiral_length(theta1)}.
}

Also there are the following meta-data for the current spiral:
\itemize{
\item \code{s$xlim}: Data range.
\item \code{s$xrange}: \code{s$xlim[2] - s$xlim[1]}.
\item \code{s$theta_lim}: The corresponding range of theta.
\item \code{s$theta_range}: \code{s$theta_lim[2] - s$theta_lim[1]}.
\item \code{s$spiral_length_lim}: The corresponding range of spiral length.
\item \code{s$spiral_length_range}: \code{s$spiral_length_lim[2] - s$spiral_length_lim[1]}.
\item \code{s$max_radius}: Radius at \code{s$theta_lim[2]}.
}
}
\examples{
spiral_initialize()
s = current_spiral()
s$curve(2*pi*2)
s$spiral_length(2*pi*2)
}
