% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{spiral_text}
\alias{spiral_text}
\title{Add texts to a track}
\usage{
spiral_text(
  x,
  y,
  text,
  offset = NULL,
  gp = gpar(),
  facing = c("downward", "inside", "outside", "clockwise", "reverse_clockwise",
    "curved_inside", "curved_outside"),
  letter_spacing = 0,
  nice_facing = FALSE,
  just = "centre",
  hjust = NULL,
  vjust = NULL,
  track_index = current_track_index(),
  ...
)
}
\arguments{
\item{x}{X-locations of the texts.}

\item{y}{Y-locations of the texts.}

\item{text}{A vector of texts.}

\item{offset}{Radial offset of the text. The value should be a \code{\link[grid:unit]{grid::unit()}} object.}

\item{gp}{Graphical parameters.}

\item{facing}{Facing of the text.}

\item{letter_spacing}{Space between two letters. The value is a fraction of the width of current letter. It only works for curved texts.}

\item{nice_facing}{If it is true, the facing will be automatically adjusted for texts which locate at different positions of the spiral. Note \code{hjust} and \code{vjust} will also be adjusted.}

\item{just}{The justification of the text relative to (x, y). The same setting as in \code{\link[grid:grid.text]{grid::grid.text()}}.}

\item{hjust}{Horizontal justification. Value should be numeric. 0 means the left of the text and 1 means the right of the text.}

\item{vjust}{Vertical justification. Value should be numeric. 0 means the bottom of the text and 1 means the top of the text.}

\item{track_index}{Index of the track.}

\item{...}{Pass to \code{\link[grid:grid.text]{grid::grid.text()}}.}
}
\value{
No value is returned.
}
\description{
Add texts to a track
}
\details{
For the curved text, it only supports one-line text.
}
\examples{
x = seq(0.1, 0.9, length = 26)
text = strrep(letters, 6)
spiral_initialize(); spiral_track()
spiral_text(x, 0.5, text)

spiral_initialize(); spiral_track()
spiral_text(x, 0.5, text, facing = "inside")

spiral_initialize(); spiral_track()
spiral_text(x, 0.5, text, facing = "outside")

x = seq(0.1, 0.9, length = 10)
text = strrep(letters[1:10], 20)
spiral_initialize(); spiral_track()
spiral_text(x, 0.5, text, facing = "curved_inside")

spiral_initialize(); spiral_track()
spiral_text(x, 0.5, text, facing = "curved_outside")
}
