% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitting.R
\name{get_split_indexes_from_stratum}
\alias{get_split_indexes_from_stratum}
\title{Generate indexes that can be used to split a stratum into two parts}
\usage{
get_split_indexes_from_stratum(
  stratum,
  method = c("random", "odd_even", "first_second"),
  replace = FALSE,
  split_p = 0.5,
  subsample_p = 1,
  careful = TRUE
)
}
\arguments{
\item{stratum}{(data frame, tibble, list, or vector) Object to split;
dataframes and tibbles are counted and split by row. All other data types
are counted and split by element}

\item{method}{(character) Splitting method. Note that \code{first_second} and
\code{odd_even} splitting method will only deliver a valid split with
default settings for other arguments (\code{subsample_p = 1, split_p = 1,
replace = TRUE})}

\item{replace}{(logical) If FALSE, splits are constructed by sampling from
stratum without replacement. If TRUE, stratum is sampled with replacement.}

\item{split_p}{(numeric) Desired joint size of both parts, expressed as a
proportion of the size of the subsampled \code{stratum}. If \code{split_p}
is larger than 1, and \code{careful} is FALSE, then parts are automatically
sampled with replacement}

\item{subsample_p}{(numeric) Subsample a proportion of \code{stratum} to be
used in the split.}

\item{careful}{(boolean) If TRUE, stop with an error when called with
arguments that may yield unexpected splits}
}
\value{
(list) List with two elements that contain indexes that can be used
  to split the stratum in two parts two splits of stratum.
}
\description{
\code{get_split_indexes_from_stratum} returns a list with indexes for
splitting its \code{stratum} argument in two parts. The splits differ at most
by one in size. With default arguments, a random split-half is returned,
which samples elements for each part from \code{stratum} without replacement.
Via additional arguments to \code{get_split_indexes_from_stratum} a range of
other splitting methods can be applied.
}
\details{
The following rounding rules apply to subsample size and split size:
\itemize{ \item If the size of the subsample, calculated as
\code{subsample_p} times size of \code{stratum}, is a fraction, then
subsample size is rounded up. \item If the joint size of the two parts,
calculated as 2 * \code{split_p} times size of the subsampled \code{stratum},
is a fraction, the part size is rounded up. \item If the joint size of the
two parts is odd and \code{replace} is FALSE, then one of the parts randomly
gets one more element than the other part. \item If the joint size of the two
parts is odd and \code{replace} is TRUE, part size is rounded up to the next
whole number, so each of the splits has the same size. }
}
\examples{
# Split-half. One of the splits gets 4 elements and the other 5
stratum = letters[1:9]
indexes = get_split_indexes_from_stratum(stratum)
apply_split_indexes_to_stratum(stratum, indexes[[1]], indexes[[2]])
}
\seealso{
Other splitting functions: 
\code{\link{apply_split_indexes_to_strata}()},
\code{\link{apply_split_indexes_to_stratum}()},
\code{\link{check_strata}()},
\code{\link{get_split_indexes_from_strata}()},
\code{\link{split_df}()},
\code{\link{split_strata}()},
\code{\link{split_stratum}()},
\code{\link{stratify}()}
}
\concept{splitting functions}
