% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-hockey.R
\name{geom_hockey}
\alias{geom_hockey}
\title{Draw Hockey Rink}
\usage{
geom_hockey(
  league,
  display_range = "full",
  rink_updates = list(),
  color_updates = list(),
  rotation = 0,
  x_trans = 0,
  y_trans = 0,
  rink_units = NULL,
  xlims = NULL,
  ylims = NULL
)
}
\arguments{
\item{league}{The league for which to draw the surface. This is
case-insensitive}

\item{display_range}{A case-insensitive string indicating the display range
to use for the plot. The default is \code{"full"}, which will be returned
when either an invalid or no value is passed to the function.

The possible display ranges are:
\describe{
\item{\code{"full"}}{The full ice surface. This is the default}
\item{\code{"in_bounds_only"}}{The full in-bounds area of the rink}
\item{\code{"in bounds only"}}{The full in-bounds area of the rink}
\item{\code{"offense"}}{The TV-right half of the rink}
\item{\code{"offence"}}{The TV-right half of the rink}
\item{\code{"defense"}}{The TV-left half of the rink}
\item{\code{"defence"}}{The TV-left half of the rink}
\item{\code{"ozone"}}{The TV-right zone of the rink}
\item{\code{"offensive_zone"}}{The TV-right zone of the rink}
\item{\code{"offensive zone"}}{The TV-right zone of the rink}
\item{\code{"attacking_zone"}}{The TV-right zone of the rink}
\item{\code{"attacking zone"}}{The TV-right zone of the rink}
\item{\code{"dzone"}}{The TV-left zone of the rink}
\item{\code{"defensive_zone"}}{The TV-left zone of the rink}
\item{\code{"defensive zone"}}{The TV-left zone of the rink}
\item{\code{"defending_zone"}}{The TV-left zone of the rink}
\item{\code{"defending zone"}}{The TV-left zone of the rink}
\item{\code{"nzone"}}{The middle zone of the rink}
\item{\code{"neutral"}}{The middle zone of the rink}
\item{\code{"neutral_zone"}}{The middle zone of the rink}
\item{\code{"neutral zone"}}{The middle zone of the rink}
}}

\item{rink_updates}{A list of updates to the rink's parameters. These will
overwrite the parameters of the league}

\item{color_updates}{A list of updates to the courts' default colors, which
are set by \code{\link[=hockey_features_set_colors]{hockey_features_set_colors()}}}

\item{rotation}{An angle, given in degrees, through which the plot should be
rotated}

\item{x_trans}{The amount that the \code{x} coordinates are to be shifted. By
convention, the +\code{x} axis extends from the center of the ice surface
towards the right-hand goal when viewing the rink in TV View}

\item{y_trans}{The amount that the \code{y} coordinates are to be shifted. By
convention, the +\code{y} axis extends from the center of the ice surface
towards the top of the rink when viewing the rink in TV view}

\item{rink_units}{The units with which to draw the rink. The default is
\code{NULL}, which will apply the rule-book specified units}

\item{xlims}{The limits on the final display in the \code{x} direction. The
default is \code{NULL}, which will utilize the \code{xlims} specified by
the \code{display_range} parameter}

\item{ylims}{The limits on the final display in the \code{y} direction. The
default is \code{NULL}, which will utilize the \code{ylims} specified by
the \code{display_range} parameter}
}
\value{
A \code{ggplot2} instance with a full-surface representation of an
ice hockey rink
}
\description{
Generate a \code{ggplot2} instance containing an ice rink for a specified
league
}
\examples{
\dontrun{
  geom_hockey(league = "NHL", rotation = 270, display_range = "ozone")
  geom_hockey(league = "iihf", rink_units = "ft")
}
}
