% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_anova.R
\name{seq_anova}
\alias{seq_anova}
\title{Sequential Analysis of Variance}
\usage{
seq_anova(
  formula,
  f,
  alpha = 0.05,
  power = 0.95,
  data,
  verbose = TRUE,
  plot = FALSE,
  seq_steps = "single"
)
}
\arguments{
\item{formula}{A formula specifying the model.}

\item{f}{Cohen's f (expected minimal effect size or effect size of interest).}

\item{alpha}{the type I error. A number between 0 and 1.}

\item{power}{1 - beta (beta is the type II error probability). A number
between 0 and 1.}

\item{data}{A data frame in which the variables specified in the formula will be found.}

\item{verbose}{a logical value whether you want a verbose output or not.}

\item{plot}{calculates the ANOVA sequentially on the data and saves the results in the slot called plot.
This calculation is necessary for the plot_anova() function.}

\item{seq_steps}{Defines the sequential steps for the sequential calculation if \code{plot = TRUE}.
Argument takes either a vector of numbers or the argument \code{single} or \code{balanced}.
A vector of numbers specifies the sample sizes at which the anova is calculated.
\code{single} specifies that after each single point the test statistic is calculated (step size = 1).
Attention: the calculation starts at the number of groups times two.
If the data do not fit to this, you have to specify the sequential steps yourself in this argument.
\code{balanced} specifies that the step size is equal to the number of groups.
Attention: the calculation starts at the number of groups times two.}
}
\value{
An object of the S4 class \code{\linkS4class{seq_anova_results}}. Click on the
class link to see the full description of the slots.
To get access to the object use the
\code{@}-operator or \verb{[]}-brackets instead of \code{$}.
See the examples below.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Performs a sequential one-way fixed effects ANOVA, see Steinhilber et al. (2023) \url{doi:10.31234/osf.io/m64ne}
for more information.
}
\examples{
# simulate data ----------------------------------------------------------------
set.seed(333)
data <- sprtt::draw_sample_normal(k_groups = 3,
                    f = 0.25,
                    sd = c(1, 1, 1),
                    max_n = 50)


# calculate sequential ANOVA ---------------------------------------------------
results <- sprtt::seq_anova(y ~ x, f = 0.25, data = data)
# test decision
results@decision
# test results
results

# calculate sequential ANOVA ---------------------------------------------------
results <- sprtt::seq_anova(y ~ x,
                            f = 0.25,
                            data = data,
                            alpha = 0.01,
                            power = .80,
                            verbose = TRUE)
results

# calculate sequential ANOVA ---------------------------------------------------
results <- sprtt::seq_anova(y ~ x,
                            f = 0.15,
                            data = data,
                            alpha = 0.05,
                            power = .80,
                            verbose = FALSE)
results
}
