// Generated by rstantools.  Do not edit by hand.

/*
    spsurv is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    spsurv is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with spsurv.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_spbp_frailty_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_spbp_frailty");
    reader.add_event(1, 1, "include", "/include/loglikbp.stan");
    reader.add_event(1, 0, "start", "/include/loglikbp.stan");
    reader.add_event(128, 127, "end", "/include/loglikbp.stan");
    reader.add_event(128, 2, "restart", "model_spbp_frailty");
    reader.add_event(270, 142, "end", "model_spbp_frailty");
    return reader;
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T9__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T9__>::type>::type, Eigen::Dynamic, 1>
loglik_null(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& beta,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& gamma,
                const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& status,
                const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& X,
                const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& b,
                const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& B,
                const int& M,
                const int& dist,
                const std::vector<int>& id,
                const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& z, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T9__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 9;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(status));
        current_statement_begin__ = 10;
        validate_non_negative_index("log_lik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(n);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 11;
        validate_non_negative_index("bp", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> bp(n);
        stan::math::initialize(bp, DUMMY_VAR__);
        stan::math::fill(bp, DUMMY_VAR__);
        current_statement_begin__ = 12;
        validate_non_negative_index("BP", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> BP(n);
        stan::math::initialize(BP, DUMMY_VAR__);
        stan::math::fill(BP, DUMMY_VAR__);
        current_statement_begin__ = 13;
        validate_non_negative_index("theta", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(n);
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta, DUMMY_VAR__);
        stan::math::assign(theta,stan::math::exp(multiply(X, beta)));
        current_statement_begin__ = 15;
        if (as_bool(logical_eq(dist, 0))) {
            current_statement_begin__ = 16;
            stan::math::assign(bp, multiply(b, gamma));
            current_statement_begin__ = 17;
            stan::math::assign(BP, multiply(B, gamma));
        } else if (as_bool(logical_eq(dist, 1))) {
            current_statement_begin__ = 20;
            stan::math::assign(bp, elt_multiply(multiply(b, gamma), stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z")));
            current_statement_begin__ = 21;
            stan::math::assign(BP, elt_multiply(multiply(B, gamma), stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z")));
        } else {
            current_statement_begin__ = 24;
            stan::math::assign(bp, elt_multiply(multiply(b, gamma), stan::math::exp(stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z"))));
            current_statement_begin__ = 25;
            stan::math::assign(BP, elt_multiply(multiply(B, gamma), stan::math::exp(stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z"))));
        }
        current_statement_begin__ = 27;
        if (as_bool(logical_eq(M, 0))) {
            current_statement_begin__ = 28;
            stan::math::assign(log_lik, subtract(elt_multiply(subtract(stan::math::log(bp), stan::math::log(add(1, BP))), status), stan::math::log(add(1, BP))));
        } else {
            current_statement_begin__ = 31;
            stan::math::assign(log_lik, subtract(elt_multiply(stan::math::log(bp), status), BP));
        }
        current_statement_begin__ = 33;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_null_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T9__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T9__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& beta,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& gamma,
                const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& status,
                const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& X,
                const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& b,
                const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& B,
                const int& M,
                const int& dist,
                const std::vector<int>& id,
                const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& z, std::ostream* pstream__) const {
        return loglik_null(beta, gamma, status, X, b, B, M, dist, id, z, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T8__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T8__>::type>::type, Eigen::Dynamic, 1>
loglik_ph(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& beta,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& gamma,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& status,
              const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& X,
              const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& b,
              const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& B,
              const int& dist,
              const std::vector<int>& id,
              const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& z, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 39;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(status));
        current_statement_begin__ = 40;
        validate_non_negative_index("log_lik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(n);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 41;
        validate_non_negative_index("h0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> h0(n);
        stan::math::initialize(h0, DUMMY_VAR__);
        stan::math::fill(h0, DUMMY_VAR__);
        current_statement_begin__ = 42;
        validate_non_negative_index("H0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> H0(n);
        stan::math::initialize(H0, DUMMY_VAR__);
        stan::math::fill(H0, DUMMY_VAR__);
        current_statement_begin__ = 43;
        validate_non_negative_index("theta", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(n);
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta, DUMMY_VAR__);
        stan::math::assign(theta,stan::math::exp(multiply(X, beta)));
        current_statement_begin__ = 45;
        if (as_bool(logical_eq(dist, 0))) {
            current_statement_begin__ = 46;
            stan::math::assign(h0, multiply(b, gamma));
            current_statement_begin__ = 47;
            stan::math::assign(H0, multiply(B, gamma));
        } else if (as_bool(logical_eq(dist, 1))) {
            current_statement_begin__ = 50;
            stan::math::assign(h0, elt_multiply(multiply(b, gamma), stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z")));
            current_statement_begin__ = 51;
            stan::math::assign(H0, elt_multiply(multiply(B, gamma), stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z")));
        } else {
            current_statement_begin__ = 54;
            stan::math::assign(h0, elt_multiply(multiply(b, gamma), stan::math::exp(stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z"))));
            current_statement_begin__ = 55;
            stan::math::assign(H0, elt_multiply(multiply(B, gamma), stan::math::exp(stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z"))));
        }
        current_statement_begin__ = 57;
        stan::math::assign(log_lik, subtract(elt_multiply(add(stan::math::log(h0), stan::math::log(theta)), status), elt_multiply(H0, theta)));
        current_statement_begin__ = 58;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_ph_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T8__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T8__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& beta,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& gamma,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& status,
              const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& X,
              const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& b,
              const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& B,
              const int& dist,
              const std::vector<int>& id,
              const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& z, std::ostream* pstream__) const {
        return loglik_ph(beta, gamma, status, X, b, B, dist, id, z, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T8__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T8__>::type>::type, Eigen::Dynamic, 1>
loglik_po(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& beta,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& gamma,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& status,
              const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& X,
              const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& b,
              const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& B,
              const int& dist,
              const std::vector<int>& id,
              const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& z, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 64;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(status));
        current_statement_begin__ = 65;
        validate_non_negative_index("log_lik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(n);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 66;
        validate_non_negative_index("r0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> r0(n);
        stan::math::initialize(r0, DUMMY_VAR__);
        stan::math::fill(r0, DUMMY_VAR__);
        current_statement_begin__ = 67;
        validate_non_negative_index("R0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> R0(n);
        stan::math::initialize(R0, DUMMY_VAR__);
        stan::math::fill(R0, DUMMY_VAR__);
        current_statement_begin__ = 68;
        validate_non_negative_index("theta", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(n);
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta, DUMMY_VAR__);
        stan::math::assign(theta,stan::math::exp(multiply(X, beta)));
        current_statement_begin__ = 70;
        if (as_bool(logical_eq(dist, 0))) {
            current_statement_begin__ = 71;
            stan::math::assign(r0, multiply(b, gamma));
            current_statement_begin__ = 72;
            stan::math::assign(R0, multiply(B, gamma));
        } else if (as_bool(logical_eq(dist, 1))) {
            current_statement_begin__ = 75;
            stan::math::assign(r0, elt_multiply(multiply(b, gamma), stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z")));
            current_statement_begin__ = 76;
            stan::math::assign(R0, elt_multiply(multiply(B, gamma), stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z")));
        } else {
            current_statement_begin__ = 79;
            stan::math::assign(r0, elt_multiply(multiply(b, gamma), stan::math::exp(stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z"))));
            current_statement_begin__ = 80;
            stan::math::assign(R0, elt_multiply(multiply(B, gamma), stan::math::exp(stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z"))));
        }
        current_statement_begin__ = 82;
        stan::math::assign(log_lik, subtract(elt_multiply(subtract(stan::math::log(elt_multiply(r0, theta)), stan::math::log(add(1, elt_multiply(R0, theta)))), status), stan::math::log(add(1, elt_multiply(R0, theta)))));
        current_statement_begin__ = 83;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_po_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T8__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T8__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& beta,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& gamma,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& status,
              const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& X,
              const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& b,
              const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& B,
              const int& dist,
              const std::vector<int>& id,
              const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& z, std::ostream* pstream__) const {
        return loglik_po(beta, gamma, status, X, b, B, dist, id, z, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T9__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T9__>::type>::type, Eigen::Dynamic, 1>
loglik_aft(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& time,
               const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& beta,
               const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gamma,
               const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& status,
               const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& X,
               const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& b,
               const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& B,
               const int& dist,
               const std::vector<int>& id,
               const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& z, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T9__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 89;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,num_elements(status));
        current_statement_begin__ = 90;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,num_elements(gamma));
        current_statement_begin__ = 91;
        validate_non_negative_index("log_lik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(n);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 92;
        validate_non_negative_index("h0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> h0(n);
        stan::math::initialize(h0, DUMMY_VAR__);
        stan::math::fill(h0, DUMMY_VAR__);
        current_statement_begin__ = 93;
        validate_non_negative_index("H0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> H0(n);
        stan::math::initialize(H0, DUMMY_VAR__);
        stan::math::fill(H0, DUMMY_VAR__);
        current_statement_begin__ = 94;
        validate_non_negative_index("theta", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(n);
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta, DUMMY_VAR__);
        stan::math::assign(theta,stan::math::exp(multiply(X, beta)));
        current_statement_begin__ = 95;
        local_scalar_t__ tau_aft(DUMMY_VAR__);
        (void) tau_aft;  // dummy to suppress unused var warning
        stan::math::initialize(tau_aft, DUMMY_VAR__);
        stan::math::fill(tau_aft, DUMMY_VAR__);
        stan::math::assign(tau_aft,(max(elt_divide(time, theta)) + 0.000001));
        current_statement_begin__ = 96;
        validate_non_negative_index("y", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y(n);
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        stan::math::assign(y,elt_divide(time, theta));
        current_statement_begin__ = 97;
        validate_non_negative_index("y_alt", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_alt(n);
        stan::math::initialize(y_alt, DUMMY_VAR__);
        stan::math::fill(y_alt, DUMMY_VAR__);
        stan::math::assign(y_alt,elt_divide(y, tau_aft));
        current_statement_begin__ = 98;
        validate_non_negative_index("b2", "n", n);
        validate_non_negative_index("b2", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> b2(n, m);
        stan::math::initialize(b2, DUMMY_VAR__);
        stan::math::fill(b2, DUMMY_VAR__);
        current_statement_begin__ = 99;
        validate_non_negative_index("B2", "n", n);
        validate_non_negative_index("B2", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> B2(n, m);
        stan::math::initialize(B2, DUMMY_VAR__);
        stan::math::fill(B2, DUMMY_VAR__);
        current_statement_begin__ = 100;
        int j(0);
        (void) j;  // dummy to suppress unused var warning
        stan::math::fill(j, std::numeric_limits<int>::min());
        stan::math::assign(j,1);
        current_statement_begin__ = 102;
        while (as_bool(logical_lt(j, (m + 1)))) {
            current_statement_begin__ = 103;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 104;
                stan::model::assign(b2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                            beta_log(get_base1(y_alt, i, "y_alt", 1), j, ((m - j) + 1)), 
                            "assigning variable b2");
                current_statement_begin__ = 105;
                stan::model::assign(B2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                            beta_cdf_log(get_base1(y_alt, i, "y_alt", 1), j, ((m - j) + 1)), 
                            "assigning variable B2");
            }
            current_statement_begin__ = 107;
            stan::math::assign(j, (j + 1));
        }
        current_statement_begin__ = 109;
        stan::math::assign(b2, elt_divide(stan::math::exp(b2), tau_aft));
        current_statement_begin__ = 110;
        stan::math::assign(B2, stan::math::exp(B2));
        current_statement_begin__ = 112;
        if (as_bool(logical_eq(dist, 0))) {
            current_statement_begin__ = 113;
            stan::math::assign(h0, multiply(b2, gamma));
            current_statement_begin__ = 114;
            stan::math::assign(H0, multiply(B2, gamma));
        } else if (as_bool(logical_eq(dist, 1))) {
            current_statement_begin__ = 117;
            stan::math::assign(h0, elt_multiply(multiply(b2, gamma), stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z")));
            current_statement_begin__ = 118;
            stan::math::assign(H0, elt_multiply(multiply(B2, gamma), stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z")));
        } else {
            current_statement_begin__ = 121;
            stan::math::assign(h0, elt_multiply(multiply(b2, gamma), stan::math::exp(stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z"))));
            current_statement_begin__ = 122;
            stan::math::assign(H0, elt_multiply(multiply(B2, gamma), stan::math::exp(stan::model::rvalue(z, stan::model::cons_list(stan::model::index_multi(id), stan::model::nil_index_list()), "z"))));
        }
        current_statement_begin__ = 124;
        stan::math::assign(log_lik, subtract(elt_multiply(subtract(stan::math::log(h0), stan::math::log(theta)), status), H0));
        current_statement_begin__ = 125;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik_aft_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T9__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T9__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& time,
               const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& beta,
               const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gamma,
               const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& status,
               const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& X,
               const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& b,
               const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& B,
               const int& dist,
               const std::vector<int>& id,
               const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& z, std::ostream* pstream__) const {
        return loglik_aft(time, beta, gamma, status, X, b, B, dist, id, z, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_spbp_frailty
  : public stan::model::model_base_crtp<model_spbp_frailty> {
private:
        int n;
        int m;
        int q;
        double tau;
        int dist;
        int null;
        int M;
        vector_d status;
        std::vector<int> id;
        vector_d time;
        matrix_d X;
        matrix_d b;
        matrix_d B;
        std::vector<int> priordist;
        std::vector<double> priorpars;
        std::vector<int> priordist_beta;
        std::vector<double> location_beta;
        std::vector<double> scale_beta;
        vector_d std;
        vector_d means;
public:
    model_spbp_frailty(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_spbp_frailty(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_spbp_frailty_namespace::model_spbp_frailty";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 133;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 1);
            current_statement_begin__ = 134;
            context__.validate_dims("data initialization", "m", "int", context__.to_vec());
            m = int(0);
            vals_i__ = context__.vals_i("m");
            pos__ = 0;
            m = vals_i__[pos__++];
            check_greater_or_equal(function__, "m", m, 1);
            current_statement_begin__ = 135;
            context__.validate_dims("data initialization", "q", "int", context__.to_vec());
            q = int(0);
            vals_i__ = context__.vals_i("q");
            pos__ = 0;
            q = vals_i__[pos__++];
            check_greater_or_equal(function__, "q", q, 1);
            current_statement_begin__ = 136;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];
            current_statement_begin__ = 137;
            context__.validate_dims("data initialization", "dist", "int", context__.to_vec());
            dist = int(0);
            vals_i__ = context__.vals_i("dist");
            pos__ = 0;
            dist = vals_i__[pos__++];
            check_greater_or_equal(function__, "dist", dist, 0);
            check_less_or_equal(function__, "dist", dist, 3);
            current_statement_begin__ = 138;
            context__.validate_dims("data initialization", "null", "int", context__.to_vec());
            null = int(0);
            vals_i__ = context__.vals_i("null");
            pos__ = 0;
            null = vals_i__[pos__++];
            check_greater_or_equal(function__, "null", null, 0);
            check_less_or_equal(function__, "null", null, 1);
            current_statement_begin__ = 139;
            context__.validate_dims("data initialization", "M", "int", context__.to_vec());
            M = int(0);
            vals_i__ = context__.vals_i("M");
            pos__ = 0;
            M = vals_i__[pos__++];
            check_greater_or_equal(function__, "M", M, 0);
            check_less_or_equal(function__, "M", M, 2);
            current_statement_begin__ = 140;
            validate_non_negative_index("status", "n", n);
            context__.validate_dims("data initialization", "status", "vector_d", context__.to_vec(n));
            status = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("status");
            pos__ = 0;
            size_t status_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < status_j_1_max__; ++j_1__) {
                status(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "status", status, 0);
            check_less_or_equal(function__, "status", status, 1);
            current_statement_begin__ = 141;
            validate_non_negative_index("id", "n", n);
            context__.validate_dims("data initialization", "id", "int", context__.to_vec(n));
            id = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("id");
            pos__ = 0;
            size_t id_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < id_k_0_max__; ++k_0__) {
                id[k_0__] = vals_i__[pos__++];
            }
            size_t id_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < id_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "id[i_0__]", id[i_0__], 0);
            }
            current_statement_begin__ = 142;
            validate_non_negative_index("time", "n", n);
            context__.validate_dims("data initialization", "time", "vector_d", context__.to_vec(n));
            time = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("time");
            pos__ = 0;
            size_t time_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < time_j_1_max__; ++j_1__) {
                time(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "time", time, 0);
            current_statement_begin__ = 145;
            validate_non_negative_index("X", "n", n);
            validate_non_negative_index("X", "q", q);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(n,q));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, q);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = q;
            size_t X_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 146;
            validate_non_negative_index("b", "n", n);
            validate_non_negative_index("b", "m", m);
            context__.validate_dims("data initialization", "b", "matrix_d", context__.to_vec(n,m));
            b = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, m);
            vals_r__ = context__.vals_r("b");
            pos__ = 0;
            size_t b_j_2_max__ = m;
            size_t b_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < b_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                    b(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 147;
            validate_non_negative_index("B", "n", n);
            validate_non_negative_index("B", "m", m);
            context__.validate_dims("data initialization", "B", "matrix_d", context__.to_vec(n,m));
            B = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, m);
            vals_r__ = context__.vals_r("B");
            pos__ = 0;
            size_t B_j_2_max__ = m;
            size_t B_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                    B(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 150;
            validate_non_negative_index("priordist", "2", 2);
            context__.validate_dims("data initialization", "priordist", "int", context__.to_vec(2));
            priordist = std::vector<int>(2, int(0));
            vals_i__ = context__.vals_i("priordist");
            pos__ = 0;
            size_t priordist_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < priordist_k_0_max__; ++k_0__) {
                priordist[k_0__] = vals_i__[pos__++];
            }
            size_t priordist_i_0_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < priordist_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "priordist[i_0__]", priordist[i_0__], 0);
            }
            current_statement_begin__ = 151;
            validate_non_negative_index("priorpars", "4", 4);
            context__.validate_dims("data initialization", "priorpars", "double", context__.to_vec(4));
            priorpars = std::vector<double>(4, double(0));
            vals_r__ = context__.vals_r("priorpars");
            pos__ = 0;
            size_t priorpars_k_0_max__ = 4;
            for (size_t k_0__ = 0; k_0__ < priorpars_k_0_max__; ++k_0__) {
                priorpars[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 154;
            validate_non_negative_index("priordist_beta", "q", q);
            context__.validate_dims("data initialization", "priordist_beta", "int", context__.to_vec(q));
            priordist_beta = std::vector<int>(q, int(0));
            vals_i__ = context__.vals_i("priordist_beta");
            pos__ = 0;
            size_t priordist_beta_k_0_max__ = q;
            for (size_t k_0__ = 0; k_0__ < priordist_beta_k_0_max__; ++k_0__) {
                priordist_beta[k_0__] = vals_i__[pos__++];
            }
            size_t priordist_beta_i_0_max__ = q;
            for (size_t i_0__ = 0; i_0__ < priordist_beta_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "priordist_beta[i_0__]", priordist_beta[i_0__], 0);
            }
            current_statement_begin__ = 155;
            validate_non_negative_index("location_beta", "q", q);
            context__.validate_dims("data initialization", "location_beta", "double", context__.to_vec(q));
            location_beta = std::vector<double>(q, double(0));
            vals_r__ = context__.vals_r("location_beta");
            pos__ = 0;
            size_t location_beta_k_0_max__ = q;
            for (size_t k_0__ = 0; k_0__ < location_beta_k_0_max__; ++k_0__) {
                location_beta[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 156;
            validate_non_negative_index("scale_beta", "q", q);
            context__.validate_dims("data initialization", "scale_beta", "double", context__.to_vec(q));
            scale_beta = std::vector<double>(q, double(0));
            vals_r__ = context__.vals_r("scale_beta");
            pos__ = 0;
            size_t scale_beta_k_0_max__ = q;
            for (size_t k_0__ = 0; k_0__ < scale_beta_k_0_max__; ++k_0__) {
                scale_beta[k_0__] = vals_r__[pos__++];
            }
            size_t scale_beta_i_0_max__ = q;
            for (size_t i_0__ = 0; i_0__ < scale_beta_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "scale_beta[i_0__]", scale_beta[i_0__], 0);
            }
            current_statement_begin__ = 159;
            validate_non_negative_index("std", "q", q);
            context__.validate_dims("data initialization", "std", "vector_d", context__.to_vec(q));
            std = Eigen::Matrix<double, Eigen::Dynamic, 1>(q);
            vals_r__ = context__.vals_r("std");
            pos__ = 0;
            size_t std_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < std_j_1_max__; ++j_1__) {
                std(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "std", std, 0);
            current_statement_begin__ = 160;
            validate_non_negative_index("means", "q", q);
            context__.validate_dims("data initialization", "means", "vector_d", context__.to_vec(q));
            means = Eigen::Matrix<double, Eigen::Dynamic, 1>(q);
            vals_r__ = context__.vals_r("means");
            pos__ = 0;
            size_t means_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < means_j_1_max__; ++j_1__) {
                means(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 165;
            validate_non_negative_index("beta", "q", q);
            num_params_r__ += q;
            current_statement_begin__ = 166;
            validate_non_negative_index("z", "n", n);
            num_params_r__ += n;
            current_statement_begin__ = 167;
            validate_non_negative_index("gamma", "m", m);
            num_params_r__ += m;
            current_statement_begin__ = 169;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_spbp_frailty() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 165;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "q", q);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(q);
        size_t beta_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 166;
        if (!(context__.contains_r("z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z");
        pos__ = 0U;
        validate_non_negative_index("z", "n", n);
        context__.validate_dims("parameter initialization", "z", "vector_d", context__.to_vec(n));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z(n);
        size_t z_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            z(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 167;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "m", m);
        context__.validate_dims("parameter initialization", "gamma", "vector_d", context__.to_vec(m));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma(m);
        size_t gamma_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 169;
        if (!(context__.contains_r("kappa")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable kappa missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, kappa);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable kappa: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 165;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(q, lp__);
            else
                beta = in__.vector_constrain(q);
            current_statement_begin__ = 166;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z;
            (void) z;  // dummy to suppress unused var warning
            if (jacobian__)
                z = in__.vector_constrain(n, lp__);
            else
                z = in__.vector_constrain(n);
            current_statement_begin__ = 167;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.vector_lb_constrain(0, m, lp__);
            else
                gamma = in__.vector_lb_constrain(0, m);
            current_statement_begin__ = 169;
            local_scalar_t__ kappa;
            (void) kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                kappa = in__.scalar_lb_constrain(0, lp__);
            else
                kappa = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 174;
            validate_non_negative_index("log_lik", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(n);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 175;
            validate_non_negative_index("nu", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> nu(m);
            stan::math::initialize(nu, DUMMY_VAR__);
            stan::math::fill(nu, DUMMY_VAR__);
            current_statement_begin__ = 177;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            stan::math::initialize(sigma, DUMMY_VAR__);
            stan::math::fill(sigma, DUMMY_VAR__);
            current_statement_begin__ = 179;
            validate_non_negative_index("beta_std", "q", q);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_std(q);
            stan::math::initialize(beta_std, DUMMY_VAR__);
            stan::math::fill(beta_std, DUMMY_VAR__);
            current_statement_begin__ = 180;
            validate_non_negative_index("gamma_std", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma_std(m);
            stan::math::initialize(gamma_std, DUMMY_VAR__);
            stan::math::fill(gamma_std, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 182;
            stan::math::assign(beta_std, elt_divide(beta, std));
            current_statement_begin__ = 183;
            if (as_bool(logical_eq(M, 2))) {
                current_statement_begin__ = 184;
                stan::math::assign(gamma_std, multiply(gamma, stan::math::exp(sum(elt_divide(elt_multiply(beta, means), std)))));
            } else {
                current_statement_begin__ = 187;
                stan::math::assign(gamma_std, multiply(gamma, stan::math::exp(-(sum(elt_divide(elt_multiply(beta, means), std))))));
            }
            current_statement_begin__ = 190;
            stan::math::assign(nu, stan::math::log(gamma));
            current_statement_begin__ = 191;
            stan::math::assign(sigma, inv_sqrt(kappa));
            current_statement_begin__ = 193;
            if (as_bool(logical_eq(null, 1))) {
                current_statement_begin__ = 194;
                stan::math::assign(log_lik, loglik_null(beta, gamma, status, X, b, B, M, dist, id, z, pstream__));
            } else {
                current_statement_begin__ = 197;
                if (as_bool(logical_eq(M, 0))) {
                    current_statement_begin__ = 198;
                    stan::math::assign(log_lik, loglik_po(beta, gamma, status, X, b, B, dist, id, z, pstream__));
                } else if (as_bool(logical_eq(M, 1))) {
                    current_statement_begin__ = 201;
                    stan::math::assign(log_lik, loglik_ph(beta, gamma, status, X, b, B, dist, id, z, pstream__));
                } else {
                    current_statement_begin__ = 204;
                    stan::math::assign(log_lik, loglik_aft(time, beta, gamma, status, X, b, B, dist, id, z, pstream__));
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 174;
            size_t log_lik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(log_lik(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: log_lik" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable log_lik: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 175;
            size_t nu_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(nu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: nu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable nu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 177;
            if (stan::math::is_uninitialized(sigma)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: sigma";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "sigma", sigma, 0);
            current_statement_begin__ = 179;
            size_t beta_std_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < beta_std_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta_std(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_std" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta_std: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 180;
            size_t gamma_std_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < gamma_std_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(gamma_std(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma_std" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable gamma_std: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "gamma_std", gamma_std, 0);
            // model body
            current_statement_begin__ = 213;
            for (int i = 1; i <= q; ++i) {
                current_statement_begin__ = 214;
                if (pstream__) {
                    stan_print(pstream__,"location = ");
                    stan_print(pstream__,get_base1(location_beta, i, "location_beta", 1));
                    stan_print(pstream__," scale = ");
                    stan_print(pstream__,get_base1(scale_beta, i, "scale_beta", 1));
                    *pstream__ << std::endl;
                }
                current_statement_begin__ = 216;
                if (as_bool(logical_eq(get_base1(priordist_beta, i, "priordist_beta", 1), 0))) {
                    current_statement_begin__ = 217;
                    lp_accum__.add(normal_log<propto__>(beta, get_base1(location_beta, i, "location_beta", 1), get_base1(scale_beta, i, "scale_beta", 1)));
                } else {
                    current_statement_begin__ = 220;
                    lp_accum__.add(cauchy_log<propto__>(beta, get_base1(location_beta, i, "location_beta", 1), get_base1(scale_beta, i, "scale_beta", 1)));
                }
            }
            current_statement_begin__ = 224;
            if (pstream__) {
                stan_print(pstream__,"h1 = ");
                stan_print(pstream__,get_base1(priorpars, 1, "priorpars", 1));
                stan_print(pstream__," h2 = ");
                stan_print(pstream__,get_base1(priorpars, 2, "priorpars", 1));
                *pstream__ << std::endl;
            }
            current_statement_begin__ = 225;
            if (as_bool(logical_eq(get_base1(priordist, 1, "priordist", 1), 1))) {
                current_statement_begin__ = 226;
                lp_accum__.add(gamma_log<propto__>(gamma, get_base1(priorpars, 1, "priorpars", 1), get_base1(priorpars, 2, "priorpars", 1)));
            } else if (as_bool(logical_eq(get_base1(priordist, 1, "priordist", 1), 2))) {
                current_statement_begin__ = 229;
                lp_accum__.add(inv_gamma_log<propto__>(gamma, get_base1(priorpars, 1, "priorpars", 1), get_base1(priorpars, 2, "priorpars", 1)));
            } else {
                current_statement_begin__ = 232;
                lp_accum__.add(lognormal_log<propto__>(gamma, get_base1(priorpars, 1, "priorpars", 1), get_base1(priorpars, 2, "priorpars", 1)));
            }
            current_statement_begin__ = 237;
            if (as_bool(logical_eq(dist, 1))) {
                current_statement_begin__ = 238;
                lp_accum__.add(gamma_log<propto__>(z, kappa, kappa));
            } else if (as_bool(logical_eq(dist, 2))) {
                current_statement_begin__ = 241;
                lp_accum__.add(normal_log<propto__>(z, 0, sigma));
            } else if (as_bool(logical_eq(dist, 3))) {
                current_statement_begin__ = 244;
                lp_accum__.add(cauchy_log<propto__>(z, 0, sigma));
            } else {
                current_statement_begin__ = 248;
                lp_accum__.add(normal_log<propto__>(z, 0, 0.000001));
            }
            current_statement_begin__ = 251;
            if (as_bool(logical_gt(dist, 0))) {
                current_statement_begin__ = 252;
                if (as_bool(logical_eq(get_base1(priordist, 2, "priordist", 1), 0))) {
                    current_statement_begin__ = 253;
                    lp_accum__.add(normal_log<propto__>(kappa, get_base1(priorpars, 3, "priorpars", 1), get_base1(priorpars, 4, "priorpars", 1)));
                } else if (as_bool(logical_eq(get_base1(priordist, 2, "priordist", 1), 1))) {
                    current_statement_begin__ = 256;
                    lp_accum__.add(gamma_log<propto__>(kappa, get_base1(priorpars, 3, "priorpars", 1), get_base1(priorpars, 4, "priorpars", 1)));
                } else if (as_bool(logical_eq(get_base1(priordist, 2, "priordist", 1), 2))) {
                    current_statement_begin__ = 259;
                    lp_accum__.add(inv_gamma_log<propto__>(kappa, get_base1(priorpars, 3, "priorpars", 1), get_base1(priorpars, 4, "priorpars", 1)));
                } else {
                    current_statement_begin__ = 262;
                    lp_accum__.add(lognormal_log<propto__>(kappa, get_base1(priorpars, 3, "priorpars", 1), get_base1(priorpars, 4, "priorpars", 1)));
                }
            }
            current_statement_begin__ = 265;
            lp_accum__.add(sum(log_lik));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("z");
        names__.push_back("gamma");
        names__.push_back("kappa");
        names__.push_back("log_lik");
        names__.push_back("nu");
        names__.push_back("sigma");
        names__.push_back("beta_std");
        names__.push_back("gamma_std");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_spbp_frailty_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(q);
        size_t beta_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z = in__.vector_constrain(n);
        size_t z_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            vars__.push_back(z(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma = in__.vector_lb_constrain(0, m);
        size_t gamma_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            vars__.push_back(gamma(j_1__));
        }
        double kappa = in__.scalar_lb_constrain(0);
        vars__.push_back(kappa);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 174;
            validate_non_negative_index("log_lik", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(n);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 175;
            validate_non_negative_index("nu", "m", m);
            Eigen::Matrix<double, Eigen::Dynamic, 1> nu(m);
            stan::math::initialize(nu, DUMMY_VAR__);
            stan::math::fill(nu, DUMMY_VAR__);
            current_statement_begin__ = 177;
            double sigma;
            (void) sigma;  // dummy to suppress unused var warning
            stan::math::initialize(sigma, DUMMY_VAR__);
            stan::math::fill(sigma, DUMMY_VAR__);
            current_statement_begin__ = 179;
            validate_non_negative_index("beta_std", "q", q);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta_std(q);
            stan::math::initialize(beta_std, DUMMY_VAR__);
            stan::math::fill(beta_std, DUMMY_VAR__);
            current_statement_begin__ = 180;
            validate_non_negative_index("gamma_std", "m", m);
            Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_std(m);
            stan::math::initialize(gamma_std, DUMMY_VAR__);
            stan::math::fill(gamma_std, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 182;
            stan::math::assign(beta_std, elt_divide(beta, std));
            current_statement_begin__ = 183;
            if (as_bool(logical_eq(M, 2))) {
                current_statement_begin__ = 184;
                stan::math::assign(gamma_std, multiply(gamma, stan::math::exp(sum(elt_divide(elt_multiply(beta, means), std)))));
            } else {
                current_statement_begin__ = 187;
                stan::math::assign(gamma_std, multiply(gamma, stan::math::exp(-(sum(elt_divide(elt_multiply(beta, means), std))))));
            }
            current_statement_begin__ = 190;
            stan::math::assign(nu, stan::math::log(gamma));
            current_statement_begin__ = 191;
            stan::math::assign(sigma, inv_sqrt(kappa));
            current_statement_begin__ = 193;
            if (as_bool(logical_eq(null, 1))) {
                current_statement_begin__ = 194;
                stan::math::assign(log_lik, loglik_null(beta, gamma, status, X, b, B, M, dist, id, z, pstream__));
            } else {
                current_statement_begin__ = 197;
                if (as_bool(logical_eq(M, 0))) {
                    current_statement_begin__ = 198;
                    stan::math::assign(log_lik, loglik_po(beta, gamma, status, X, b, B, dist, id, z, pstream__));
                } else if (as_bool(logical_eq(M, 1))) {
                    current_statement_begin__ = 201;
                    stan::math::assign(log_lik, loglik_ph(beta, gamma, status, X, b, B, dist, id, z, pstream__));
                } else {
                    current_statement_begin__ = 204;
                    stan::math::assign(log_lik, loglik_aft(time, beta, gamma, status, X, b, B, dist, id, z, pstream__));
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 177;
            check_greater_or_equal(function__, "sigma", sigma, 0);
            current_statement_begin__ = 180;
            check_greater_or_equal(function__, "gamma_std", gamma_std, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t log_lik_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                    vars__.push_back(log_lik(j_1__));
                }
                size_t nu_j_1_max__ = m;
                for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
                    vars__.push_back(nu(j_1__));
                }
                vars__.push_back(sigma);
                size_t beta_std_j_1_max__ = q;
                for (size_t j_1__ = 0; j_1__ < beta_std_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_std(j_1__));
                }
                size_t gamma_std_j_1_max__ = m;
                for (size_t j_1__ = 0; j_1__ < gamma_std_j_1_max__; ++j_1__) {
                    vars__.push_back(gamma_std(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_spbp_frailty";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t log_lik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t nu_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "nu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma";
            param_names__.push_back(param_name_stream__.str());
            size_t beta_std_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < beta_std_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_std" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gamma_std_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < gamma_std_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma_std" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t log_lik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t nu_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "nu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma";
            param_names__.push_back(param_name_stream__.str());
            size_t beta_std_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < beta_std_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_std" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gamma_std_j_1_max__ = m;
            for (size_t j_1__ = 0; j_1__ < gamma_std_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma_std" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_spbp_frailty_namespace::model_spbp_frailty stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
