#' This class represents a list of fields.
#'
#' Used to define a list of ExprField instances for the INSERT query.
#'
#' @examples
#' # To generate the list of fields "id", "title", "year":
#' ExprListFields$new(list(ExprField$new("id"),
#'                         ExprField$new("title"),
#'                         ExprField$new("year")))
#'
#' @import R6
#' @include ExprList.R
#' @include TokenSymbol.R
#' @export
ExprListFields <- R6::R6Class("ExprListFields",
  inherit = ExprList,
  public = list(

    #' @description
    #' Initializer.
    #' @param fields A list of ExprField instances.
    #' @return Nothing.
    initialize = function(fields) {
      chk::chk_all(fields, chk::chk_is, "ExprField")
      super$initialize(fields)
      return(invisible(NULL))
    }
))
