#' TokenKeyword class.
#'
#' Represents an SQL keyword such as SELECT, FROM, WHERE, etc.
#'
#' @examples
#' # No example since this class is not exported.
#'
#' @import R6
#' @include Token.R
TokenKeyword <- R6::R6Class("TokenKeyword",
  inherit = Token,
  public = list(

    #' @description
    #' Initializer.
    #' @param kwd The keyword.
    #' @return Nothing.
    initialize = function(kwd) {
      chk::chk_string(kwd)
      private$kwd <- kwd
      return(invisible(NULL))
    },

    #' @description
    #' Converts into a string.
    #' @return A string containing the SQL expression.
    toString = function() {
      return(apply_case(private$kwd))
    }
  ),
  private = list(
    kwd = NULL
  )
)
