testthat::context("ExprUnaryOp class")

testthat::test_that("Initializer works fine", {
  testthat::expect_error(ExprUnaryOp$new())
  testthat::expect_error(ExprUnaryOp$new("not"))
  ExprUnaryOp$new("not", ExprField$new("flag"))
})

testthat::test_that("Conversion to string works fine", {
  x <- ExprUnaryOp$new("not", ExprField$new("flag"))
  testthat::expect_equal(x$toString(), "(NOT flag)")
  x$enableParenthesis(FALSE)
  testthat::expect_equal(x$toString(), "NOT flag")

  x <- ExprUnaryOp$new("-", ExprValue$new(12L))
  testthat::expect_equal(x$toString(), "(- 12)")
})
