testthat::context("Statement Set class")

testthat::test_that("We can create a simple SET statement with the constructor",
{
  set <- StmtSet$new()
  set$add_field(ExprField$new('price'), ExprValue$new(9.50))
  testthat::expect_equal(set$toString(), "SET price = 9.5")
})

testthat::test_that("We can create a SET statement with two columns",
{
  set <- StmtSet$new()
  set$add_field(ExprField$new('price'), ExprValue$new(9.50))
  set$add_field(ExprField$new('old'), ExprValue$new(TRUE))
  testthat::expect_equal(set$toString(), 'SET price = 9.5, "old" = TRUE')
})

testthat::test_that("We can create a SET statement using with the factory",
{
  testthat::expect_equal(make_set(price=9.50, old=TRUE)$toString(),
                         'SET price = 9.5, "old" = TRUE')
})
