% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_re.R
\name{calculate_re}
\alias{calculate_re}
\title{Calculate relative error}
\usage{
calculate_re(dat, add = TRUE)
}
\arguments{
\item{dat}{An input data frame. Should be either a scalar or time series
data frame as returned from \code{\link{get_results_all}} or a related
get results function. Specifically, the data frame needs to have columns
with \code{_em} and \code{_om} as names.}

\item{add}{Logical: should the relative error columns be added to \code{dat}
or should the original EM and OM columns be dropped? If \code{FALSE} then
the returned data frame will have only the identifying columns and the new
relative error columns. You could then merge selected columns back into
\code{dat} if you wished. The default is to return all columns.}
}
\value{
The default is to return a data frame structured the same as the 
input data frame, i.e., \code{dat}, but with additional columns, where 
\code{'_re'} is appended to the base string of the column name.
All \code{NAN} and \code{Inf} values are returned as \code{NA} values,
typically because you cannot divide by zero.
}
\description{
Calculate the relative error (RE; [EM - OM]/OM) of 
parameters and derived quantities stored in a scalar or time series 
data frame generated by \code{\link{get_results_all}}.
}
\examples{
# Example with built in package data:
data("ts_dat", package = "ss3sim")
data("scalar_dat", package = "ss3sim")
head(calculate_re(ts_dat))
head(calculate_re(ts_dat, add = FALSE))
head(calculate_re(scalar_dat, add = FALSE))
rm("ts_dat", "scalar_dat")

}
\seealso{
\code{\link{get_results_all}}, \code{link{get_results_scenario}}
}
\author{
Sean Anderson and Cole Monnahan
}
