% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_ss3models.r
\name{copy_ss3models}
\alias{copy_ss3models}
\title{Copy the operating and estimation models and create a folder
structure}
\usage{
copy_ss3models(model_dir, scenarios, iterations = 1:100, type = c("om",
  "em"))
}
\arguments{
\item{model_dir}{A directory containing the operating or estimation
model. Each folder should be named according to a scenario ID. (See
the vignette \code{vignette("ss3sim-vignette")} or
\code{\link{get_caseargs}} for details on the scenario ID format.)}

\item{scenarios}{Which scenarios to copy to. Supply a vector of
character elements.}

\item{iterations}{A numeric vector of the iterations to copy to.
The function will create the folders as needed.}

\item{type}{Are you copying operating or estimation models? This
affects whether the model folder gets named "om" or "em"}
}
\value{
An invisible boolean for whether that iteration already
existed. A set of nested folders starting with the scenario ID, then the
iterations, then "om" or "em", and then the SS model files.
}
\description{
Copy the operating and estimation models and create a folder
structure
}
\examples{
# Locate the package data:
om_folder <- system.file("extdata", "models", "cod-om", package =
  "ss3sim")

# Copy the operating model:
copy_ss3models(model_dir = om_folder, type = "om", iterations =
  1:3, scenarios = "D0-F0-testing")
# Now look at your working directory in your file system

# Copy the estimation model with two scenario IDs:
copy_ss3models(model_dir = om_folder, type = "em", iterations = 1:2,
  scenarios = c("D1-F0-testing", "D2-F0-testing"))
# (Note that all the scenario argument does here is affect the
# folder names.)

# Clean up:
unlink("D0-F0-testing", recursive = TRUE)
unlink("D1-F0-testing", recursive = TRUE)
unlink("D2-F0-testing", recursive = TRUE)
}
\author{
Sean Anderson, Kelli Johnson
}
