% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_mlacomp.R
\name{sample_mlacomp}
\alias{sample_mlacomp}
\title{[BETA VERSION] Sample mean length (size-)-at-age data and write to file for use by the EM.}
\usage{
sample_mlacomp(dat_list, outfile, ctl_file_in, fleets = 1, Nsamp, years,
  mean_outfile = NULL, verbose = TRUE)
}
\arguments{
\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{outfile}{A character string specifying the file name to use
when writing the information to the disk. The string must include
the proper file extension. No file is written using the default value
of \code{NULL}, which leads to increased speed because writing the 
file takes time and computing resources.}

\item{ctl_file_in}{A path to the control file, output from an OM, containing
the OM parameters for growth. These values are used to determine the
uncertainty about size for fish sampled in each age bin.}

\item{fleets}{*A vector of integers specifying which fleets to include.
The order of the fleets pertains to the input order of other arguments.
An entry of \code{fleets=NULL} leads to zero samples for any fleet.}

\item{Nsamp}{*A numeric list of the same length as \code{fleets}.
Either single values or vectors of the same length as the number of
years can be passed through. Single values are repeated for all
years. If no fleet collected samples, keep the value to
\code{Nsamp=NULL}.}

\item{years}{*A list the same length as \code{fleets} giving the years as
numeric vectors. If no fleet collected samples, keep the value to
\code{years=NULL}.}

\item{mean_outfile}{A path to write length and age data for external
estimation of parametric growth. If \code{NULL} no file will be written.
This file is used by \code{change_e} to externally estimate growth
parameters. Filename must contain "vbgf" to be used by \code{change_e}.
Also, if "remove" is included in the filename, the mean length at age data
will be removed from the \code{.dat} file and not be available to the EM.}

\item{verbose}{Logical value whether or not diagnostic information from
\pkg{r4ss} functions should be printed to the screen. Default is FALSE.}
}
\value{
A modified \code{.dat} file if \code{!is.null(outfile)}. A list object
containing the modified \code{.dat} file is returned invisibly.
}
\description{
[BETA VERSION] Sample mean length (size-)-at-age data and write to file for use by the EM.
}
\details{
**This function is in beta and untested. Use with caution.**
Take a \code{data.SS_new} file, read in by \pkg{r4ss} function
  \code{\link[r4ss]{SS_readdat}} containing observed values, and
  sample from the observed ages to get realistic proportions for the number
  of fish in each age bin, then use the mean size-at-age and CV for growth to
  generate random samples of size, which are then averaged to get mean
  length-at-age values. These values are then written to file for the
  EM.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\examples{
d <- system.file(file.path("extdata", "models", "cod-om"),
  package = "ss3sim")
dat_in <- file.path(d, "codOM.dat")
dat_list <- r4ss::SS_readdat(dat_in, version = NULL, verbose = FALSE)
dat_list <- change_data(dat_list, outfile = NULL,
  fleets = 1, years = seq(dat_list$styr, dat_list$styr + 5),
  types = c("age", "mla"))
ctl_file_in <- file.path(d, "codOM.ctl")

out <- sample_mlacomp(dat_list, outfile = NULL, ctl_file_in = ctl_file_in,
  fleets = 1, Nsamp = 30, years = list(dat_list$styr + 5),
  verbose = FALSE, mean_outfile = NULL)

}
\seealso{
Other sampling functions: \code{\link{clean_data}},
  \code{\link{sample_agecomp}},
  \code{\link{sample_calcomp}}, \code{\link{sample_index}},
  \code{\link{sample_lcomp}}, \code{\link{sample_wtatage}}
}
\author{
Cole Monnahan, Kelli Johnson
}
\concept{sampling functions}
