% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssimparser.R
\name{load_ssim}
\alias{load_ssim}
\title{load_ssim}
\usage{
load_ssim(
  ssim_file = get_ssim_sample(),
  nested_df = FALSE,
  collist = get_ssim_collist(getall = FALSE),
  clean_col_names = TRUE,
  unpivot_days_of_op = FALSE,
  expand_sched = FALSE
)
}
\arguments{
\item{ssim_file}{Path to the SSIM file or character vector containing the content to load.}

\item{nested_df}{Nest SSIM type 3 into type 2 (TRUE/FALSE). Default to FALSE.}

\item{collist}{List of columns that need to be present in the final Data Frame. get_ssim_collist() to get the full list.}

\item{clean_col_names}{Clean column names in the final Data Frame by removing type2/type3 prefixes (TRUE/FALSE). Default TRUE.}

\item{unpivot_days_of_op}{Unpivot the schedules by creating a schedule by day of operation (TRUE/FALSE). Default FALSE.}

\item{expand_sched}{Expand schedules into flights.}
}
\value{
Data Frame (nested or not) containing the schedules (or flights when schedules were expanded).
}
\description{
Load SSIM file into a Data Frame.
}
\examples{
# Get a sample as a character vector
sample_ssim_string <- ssimparser::get_ssim_sample(datefrom = as.Date("2020-11-01"),
dateto = as.Date("2020-12-01"),
season = "W20",
creadate = as.Date("2020-12-02"))

# Write sample to temp dir
sample_ssim_file <- tempfile()
write(sample_ssim_string, sample_ssim_file, append = FALSE)

# Load sample, expand schedules to flights and display the traffic
# by month and departure airport ICAO
ssimparser::load_ssim(ssim_file = sample_ssim_file,
expand_sched = TRUE) \%>\%
dplyr::group_by(format(flight.flight_date,"\%Y-\%m"), adep_icao) \%>\%
dplyr::summarise(n=dplyr::n())

# Get the unique list of airports ICAO
ssimparser::load_ssim(ssim_file = sample_ssim_file, expand_sched = TRUE,
collist = c("type3.adep_icao", "type3.ades_icao")) \%>\% unique()

# Nest the type 3 into type 2
ssim_nested <- ssimparser::load_ssim(ssim_file = sample_ssim_file,
expand_sched = FALSE, nested = TRUE)
head(ssim_nested)

# Remove the sample SSIM file
unlink(sample_ssim_file)
}
