% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_best_bin_rank.R
\name{sim_power_best_bin_rank}
\alias{sim_power_best_bin_rank}
\title{Simulate Power to Rank the Best Group Using Binomial Outcomes}
\usage{
sim_power_best_bin_rank(
  noutcomes,
  p1,
  dif,
  weights,
  ngroups,
  npergroup,
  nsim,
  conf.level = 0.95
)
}
\arguments{
\item{noutcomes}{Integer. Number of outcomes to evaluate.}

\item{p1}{Numeric. Event probability in the best group (scalar or vector of length \code{noutcomes}).}

\item{dif}{Numeric. Difference between the best group and the rest (scalar or vector of length \code{noutcomes}).}

\item{weights}{Numeric vector. Weights for each outcome. If scalar, applied equally.}

\item{ngroups}{Integer. Number of groups.}

\item{npergroup}{Integer or vector. Sample size per group.}

\item{nsim}{Integer. Number of simulations.}

\item{conf.level}{Numeric. Confidence level for the empirical power estimate#'}
}
\value{
An S3 object of class \code{empirical_power_result}, which contains
the estimated empirical power and its confidence interval. The object can
be printed, formatted, or further processed using associated S3 methods.
See also \code{\link{empirical_power_result}}.
}
\description{
Estimates the empirical power to rank the most promising group as the best,
based on binomial outcomes, via simulation.
}
\details{
Each outcome is assumed to follow an independent binomial distribution. The
best group is defined as having a probability at least \code{dif} higher than the
other groups. The function sums weighted ranks across multiple outcomes to
determine the top group.

If multiple outcomes are defined, weights can be applied to prioritize some
outcomes over others. Weights are automatically scaled to sum 1. The group
with the lowest total rank is considered the best.
}
\examples{
  sim_power_best_bin_rank(
  noutcomes = 2,
  p1 = 0.80,
  dif = 0.15,
  weights = 1,
  ngroups = 3,
  npergroup = 30,
  nsim = 1000,
  conf.level = 0.95)
}
\seealso{
\code{\link{empirical_power_result}}
}
