% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{geom_eempeakloc}
\alias{geom_eempeakloc}
\title{Mark common EEM peaks}
\usage{
geom_eempeakloc(data = peaks, ...)
}
\arguments{
\item{data}{data.frame containing information about the peaks, such as names, locations and ranges}

\item{...}{additional arguments to be passed on to \code{\link[ggplot2]{geom_function}}}
}
\value{
a layer to a ggplot2
}
\description{
geom_eempeakloc marks the locations of commonly used peaks to EEMs of water samples
}
\details{
data, the data.frame with the peaks, is included in the package and accessible using data(peaks).
It is possible to alter that data.frame and e.g. provide altered peaks or a selection of peaks using common functions on data.frames.
geom_eempeakloc plots several labels which can be close together in smaller plots. By default, labels are omitted to keep it readable, but this means important information is lost.
If the ggrepel package is installed, it is used for plotting the labels and the result is much more convenient. You have to install ggrepel manually to use it with this function.
}
\examples{
require(tidyr)

eem_list \%>\%
  eem_extract(eem_names((eem_list))[1], keep = TRUE) \%>\%
  ggeem() +
  geom_eempeakloc()

# We plot only component 3 of the PARAFAC model to avoid letter overload
pf4[[1]] \%>\%
  (\(x, comp = 3) { #please change comp to the index of the comp. to plot.
    x$A <- x$A[, comp, drop = FALSE]
    x$B <- x$B[, comp, drop = FALSE]
    x$C <- x$C[, comp, drop = FALSE]
    x
  })() \%>\%
  ggeem() +
  geom_eempeakloc() +
  coord_cartesian(xlim = c(250,455), ylim = c(290,578))
}
