% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages_csbhc.R
\name{stages_csbhc}
\alias{stages_csbhc}
\title{Context-specific Backward hill-climbing}
\usage{
stages_csbhc(
  object,
  score = function(x) {
     return(-BIC(x$ll))
 },
  max_iter = Inf,
  scope = NULL,
  ignore = object$name_unobserved
)
}
\arguments{
\item{object}{an object of class \code{sevt} with fitted probabilities and
data, as returned by \code{full} or \code{sevt_fit}.}

\item{score}{the score function to be maximized.}

\item{max_iter}{the maximum number of iterations per variable.}

\item{scope}{names of variables that should be considered for the optimization.}

\item{ignore}{vector of stages which will be ignored and left untouched,
by default the name of the unobserved stages stored in
\code{object$name_unobserved}.}
}
\value{
The final staged event tree obtained.
}
\description{
Greedy search of staged event trees with
iterative joining of stages.
}
\details{
For each variable the algorithm tries to join stages
, by adding context specific independences,
and moves to the best model that increases the score. When no
increase is possible it moves to the next variable.
}
\examples{
model <- stages_csbhc(full(Titanic))
summary(model)
}
