% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanza.R
\name{stanza_pipeline}
\alias{stanza_pipeline}
\title{NLP Pipeline}
\usage{
stanza_pipeline(
  language = "en",
  model_dir = stanza_options("model_dir"),
  package = "default",
  processors = list(),
  logging_level = "INFO",
  use_gpu = FALSE,
  download_method = "reuse_resources",
  ...
)
}
\arguments{
\item{language}{a character string giving the language (default is \code{"en"}).}

\item{model_dir}{path to the directory for storing the for \code{Stanza} models
(default is \code{"~/stanza_resources"}).}

\item{package}{(default is \code{"default"}.}

\item{processors}{FIXME: we should define if we want to use comma seperated string or a character vector.}

\item{logging_level}{a character string giving the logging level (default is \code{"INFO"}),
available levels are \code{c('DEBUG', 'INFO', 'WARNING', 'WARN', 'ERROR', 'CRITICAL', 'FATAL')}.}

\item{use_gpu}{a logical giving if \code{GPU} or \code{CPU} should be used (default is \code{FALSE}).}

\item{download_method}{an integer or character string giving the download method code.
If a character string is provided, it is passed to \code{stanza_download_method_code}
to obtain the integer code.
Use \code{stanza_download_method_code} to obtain the code and list all
available download methods.}

\item{...}{additional named arguments passed to the stanza pipeline.}
}
\value{
a function that can be used to process text.
}
\description{
NLP Pipeline
}
\examples{
\dontrun{
p <- stanza_pipeline()
doc <- p('R is a programming language for statistical computing.')
}

}
