% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/starsTileServer.R
\name{starsTileServer}
\alias{starsTileServer}
\title{A R6 class that extends plumber to function as a tile server}
\description{
Creates a tile server based on the R6 class \code{plumber::Plumber}.
In can be created both with a \code{stars} grid as well as a function or list of functions.
The main methods are \code{run} and \code{new}.
}
\examples{
m <- matrix(1:20, nrow = 5, ncol = 4)
dim(m) <- c(x = 5, y = 4) # named dim
(s <- stars::st_as_stars(m))
sf::st_crs(s) <- 4326
starsTileServer$new(s)
# Working directly from a file
grid <- system.file("tif/L7_ETMs.tif", package = "stars")
starsTileServer$new(grid)
\dontrun{
starsTileServer$new(s)$run()
}
}
\section{Super classes}{
\code{\link[plumber:Hookable]{plumber::Hookable}} -> \code{\link[plumber:Plumber]{plumber::Plumber}} -> \code{starsTileServer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-starsTileServer-new}{\code{starsTileServer$new()}}
\item \href{#method-starsTileServer-add_tile_endpoint}{\code{starsTileServer$add_tile_endpoint()}}
\item \href{#method-starsTileServer-get_grid}{\code{starsTileServer$get_grid()}}
\item \href{#method-starsTileServer-get_attributes}{\code{starsTileServer$get_attributes()}}
\item \href{#method-starsTileServer-get_dimensions}{\code{starsTileServer$get_dimensions()}}
\item \href{#method-starsTileServer-get_dimension_values_chr}{\code{starsTileServer$get_dimension_values_chr()}}
\item \href{#method-starsTileServer-get_non_spatial_dimensions}{\code{starsTileServer$get_non_spatial_dimensions()}}
\item \href{#method-starsTileServer-clone}{\code{starsTileServer$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Hookable" data-id="registerHooks"><a href='../../plumber/html/Hookable.html#method-Hookable-registerHooks'><code>plumber::Hookable$registerHooks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="addAssets"><a href='../../plumber/html/Plumber.html#method-Plumber-addAssets'><code>plumber::Plumber$addAssets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="addEndpoint"><a href='../../plumber/html/Plumber.html#method-Plumber-addEndpoint'><code>plumber::Plumber$addEndpoint()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="addFilter"><a href='../../plumber/html/Plumber.html#method-Plumber-addFilter'><code>plumber::Plumber$addFilter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="addGlobalProcessor"><a href='../../plumber/html/Plumber.html#method-Plumber-addGlobalProcessor'><code>plumber::Plumber$addGlobalProcessor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="call"><a href='../../plumber/html/Plumber.html#method-Plumber-call'><code>plumber::Plumber$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="filter"><a href='../../plumber/html/Plumber.html#method-Plumber-filter'><code>plumber::Plumber$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="getApiSpec"><a href='../../plumber/html/Plumber.html#method-Plumber-getApiSpec'><code>plumber::Plumber$getApiSpec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="getDebug"><a href='../../plumber/html/Plumber.html#method-Plumber-getDebug'><code>plumber::Plumber$getDebug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="handle"><a href='../../plumber/html/Plumber.html#method-Plumber-handle'><code>plumber::Plumber$handle()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="mount"><a href='../../plumber/html/Plumber.html#method-Plumber-mount'><code>plumber::Plumber$mount()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="onHeaders"><a href='../../plumber/html/Plumber.html#method-Plumber-onHeaders'><code>plumber::Plumber$onHeaders()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="onWSOpen"><a href='../../plumber/html/Plumber.html#method-Plumber-onWSOpen'><code>plumber::Plumber$onWSOpen()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="openAPIFile"><a href='../../plumber/html/Plumber.html#method-Plumber-openAPIFile'><code>plumber::Plumber$openAPIFile()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="print"><a href='../../plumber/html/Plumber.html#method-Plumber-print'><code>plumber::Plumber$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="registerHook"><a href='../../plumber/html/Plumber.html#method-Plumber-registerHook'><code>plumber::Plumber$registerHook()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="removeHandle"><a href='../../plumber/html/Plumber.html#method-Plumber-removeHandle'><code>plumber::Plumber$removeHandle()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="route"><a href='../../plumber/html/Plumber.html#method-Plumber-route'><code>plumber::Plumber$route()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="run"><a href='../../plumber/html/Plumber.html#method-Plumber-run'><code>plumber::Plumber$run()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="serve"><a href='../../plumber/html/Plumber.html#method-Plumber-serve'><code>plumber::Plumber$serve()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="set404Handler"><a href='../../plumber/html/Plumber.html#method-Plumber-set404Handler'><code>plumber::Plumber$set404Handler()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="setApiSpec"><a href='../../plumber/html/Plumber.html#method-Plumber-setApiSpec'><code>plumber::Plumber$setApiSpec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="setDebug"><a href='../../plumber/html/Plumber.html#method-Plumber-setDebug'><code>plumber::Plumber$setDebug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="setDocs"><a href='../../plumber/html/Plumber.html#method-Plumber-setDocs'><code>plumber::Plumber$setDocs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="setDocsCallback"><a href='../../plumber/html/Plumber.html#method-Plumber-setDocsCallback'><code>plumber::Plumber$setDocsCallback()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="setErrorHandler"><a href='../../plumber/html/Plumber.html#method-Plumber-setErrorHandler'><code>plumber::Plumber$setErrorHandler()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="setParsers"><a href='../../plumber/html/Plumber.html#method-Plumber-setParsers'><code>plumber::Plumber$setParsers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="setSerializer"><a href='../../plumber/html/Plumber.html#method-Plumber-setSerializer'><code>plumber::Plumber$setSerializer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="swaggerFile"><a href='../../plumber/html/Plumber.html#method-Plumber-swaggerFile'><code>plumber::Plumber$swaggerFile()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Plumber" data-id="unmount"><a href='../../plumber/html/Plumber.html#method-Plumber-unmount'><code>plumber::Plumber$unmount()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-starsTileServer-new"></a>}}
\if{latex}{\out{\hypertarget{method-starsTileServer-new}{}}}
\subsection{Method \code{new()}}{
This method is used to initialize a new tile server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{starsTileServer$new(grid, colorFun = NULL, tileSize = 256, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grid}}{Either a stars grid, a path pointing towards a gridded file, a function or a list of named functions}

\item{\code{colorFun}}{a color function to use for coloring the map tiles, the function needs to be the same format as \code{\link[leaflet:colorNumeric]{leaflet::colorNumeric()}}. It is important to specify a color function as it is important to keep the range of the color scale similar between tiles, therefore the minimum and maximum needs to be fixed. It can also be a list of color functions.}

\item{\code{tileSize}}{The size of the tile (generally 256 pixels, and not tested with other sizes)}

\item{\code{...}}{Arguments passed on to the \link[plumber:Plumber]{plumber::Plumber}, most important is the \code{port} number.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If \code{grid} is a function it should take a stars grid as the first argument and return the grid with the same topology with values attached.
Any other arguments to the function will be part of the API and will be passed to the function as characters.
}

\subsection{Returns}{
An \code{starsTileServer} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-starsTileServer-add_tile_endpoint"></a>}}
\if{latex}{\out{\hypertarget{method-starsTileServer-add_tile_endpoint}{}}}
\subsection{Method \code{add_tile_endpoint()}}{
Add three endpoints to the tile server, to return both the tiles and the color scale used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{starsTileServer$add_tile_endpoint(prefix, handlerFun, colorFun, params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{the name to be used by the server for this tile server}

\item{\code{handlerFun}}{The function that handles the api request and returns the grid}

\item{\code{colorFun}}{The color function to use for example \code{\link[leaflet:colorNumeric]{leaflet::colorNumeric()}}}

\item{\code{params}}{parameters passed on to the \code{new} method of \link[plumber:PlumberEndpoint]{plumber::PlumberEndpoint}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-starsTileServer-get_grid"></a>}}
\if{latex}{\out{\hypertarget{method-starsTileServer-get_grid}{}}}
\subsection{Method \code{get_grid()}}{
return the grid used to initialize the function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{starsTileServer$get_grid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-starsTileServer-get_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-starsTileServer-get_attributes}{}}}
\subsection{Method \code{get_attributes()}}{
return the attributes of the stars grid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{starsTileServer$get_attributes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-starsTileServer-get_dimensions"></a>}}
\if{latex}{\out{\hypertarget{method-starsTileServer-get_dimensions}{}}}
\subsection{Method \code{get_dimensions()}}{
return the names of the dimensions of the grid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{starsTileServer$get_dimensions()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-starsTileServer-get_dimension_values_chr"></a>}}
\if{latex}{\out{\hypertarget{method-starsTileServer-get_dimension_values_chr}{}}}
\subsection{Method \code{get_dimension_values_chr()}}{
return the values of a dimension as a character
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{starsTileServer$get_dimension_values_chr(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{the name of the dimension}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-starsTileServer-get_non_spatial_dimensions"></a>}}
\if{latex}{\out{\hypertarget{method-starsTileServer-get_non_spatial_dimensions}{}}}
\subsection{Method \code{get_non_spatial_dimensions()}}{
return all non spatial dimensions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{starsTileServer$get_non_spatial_dimensions()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-starsTileServer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-starsTileServer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{starsTileServer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
