% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statis.R
\name{statis}
\alias{statis}
\title{STATIS Method}
\usage{
statis(
  matrices,
  selected.tables = NULL,
  selected.rows = NULL,
  table.labels = NULL
)
}
\arguments{
\item{matrices}{List of numeric matrices (at least 2), all with the same number of rows (individuals).}

\item{selected.tables}{Select a subset of tables. If \code{NULL}, all tables are included.}

\item{selected.rows}{Select a subset of rows. If \code{NULL}, all rows are included.}

\item{table.labels}{Optional vector with names for the tables. It must have the same length as the number of tables.}
}
\value{
A list with the following elements:
\item{n}{Number of rows (individuals).}
\item{r}{Number of tables.}
\item{p}{Vector with the number of columns per table.}
\item{S}{List of centered matrices.}
\item{W}{List of proximity matrices.}
\item{X}{Matrix of interstructure (vectorization of W).}
\item{acp.inter}{PCA results of the interstructure: eigenvalues, eigenvectors, components, correlations.}
\item{XT}{Weighted average of the matrices.}
\item{acp.intra}{PCA results of the average: eigenvalues, eigenvectors, components, correlations.}
\item{IND}{Concatenated matrix with all W stacked (individual evolution).}
\item{Omega}{Projection of individual evolution onto the principal components.}
\item{circle.inter}{Data to plot the correlation circle between tables.}
\item{circle.intra}{Data to plot the variable evolution circle.}
\item{plane.individuals}{Data to plot the average individuals plane.}
\item{plane.evolution}{Data to plot the evolution of the individuals.}
}
\description{
Applies the STATIS method to a set of matrices (data tables) with the same rows.
Is a multivariate analysis technique that allows studying the common structure
and the evolution of individuals and variables across multiple tables.
}
\examples{
data(expert1, expert2, expert3)

labels <- c("Expert 1", "Expert 2", "Expert 3")

# If you want to select an specific table or tables
res <- statis(list(expert1, expert2, expert3), selected.tables = c(1, 3), table.labels = labels)

# If you want to select an specific row or rows
res <- statis(list(expert1, expert2, expert3), selected.rows = c(1, 5), table.labels = labels)

# If you want to select some tables and rows at the same time
res <- statis(list(expert1,expert2,expert3), selected.tables=c(1, 3), selected.rows=c(1, 4), labels)

# All tables and rows selected
res <- statis(list(expert1, expert2, expert3), table.labels = labels)

# How to use res
inter <- res$circle.inter
plot.statis.circle(inter$points, inter$inertia, inter$labels, inter$title)

evolution <- res$plane.evolution
plot.statis.plane(evolution$points, evolution$inertia, evolution$labels, evolution$title)

}
\seealso{
\code{\link{plot.statis.circle}}, \code{\link{plot.statis.plane}}
}
