% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.stdmean2}
\alias{ci.stdmean2}
\title{Confidence intervals for a 2-group standardized mean difference}
\usage{
ci.stdmean2(alpha, m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 4-row matrix. The columns are:
\itemize{
\item Estimate - estimated standardized mean difference
\item adj Estimate - bias adjusted standardized mean difference estimate
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for a population standardized mean difference.
Unweighted, weighted, and single group variance standardizers are used. The
square root weighted variance standardizer is recommended in 2-group
nonexperimental designs with simple random sampling. The square root
unweighted variance standardizer is recommended in 2-group experimental
designs. The single group standard deviation standardizer can be used with
experimental or nonexperimental designs. Equality of variances is not
assumed.
}
\examples{
ci.stdmean2(.05, 35.1, 26.7, 7.32, 6.98, 30, 30)

# Should return:
#                          Estimate  adj Estimate        SE        LL       UL
# Unweighted standardizer: 1.174493      1.159240 0.2844012 0.6170771 1.731909
# Weighted standardizer:   1.174493      1.159240 0.2802826 0.6251494 1.723837
# Group 1 standardizer:    1.147541      1.117605 0.2975582 0.5643375 1.730744
# Group 2 standardizer:    1.203438      1.172044 0.3120525 0.5918268 1.815050


}
\references{
\insertRef{Bonett2008}{statpsych}
}
