% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.ratio.prop2}
\alias{size.ci.ratio.prop2}
\title{Sample size for a 2-group proportion ratio confidence interval}
\usage{
size.ci.ratio.prop2(alpha, p1, p2, r, R)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{p1}{planning value of proportion for group 1}

\item{p2}{planning value of proportion for group 2}

\item{r}{desired upper to lower confidence interval endpoint ratio}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group required to estimate a ratio of
proportions with desired confidence interval precision in a 2-group design.
Set R = 1 for equal sample sizes.
}
\examples{
size.ci.ratio.prop2(.05, .2, .1, 2, 1)

# Should return:
#   n1  n2
#  416 416

size.ci.ratio.prop2(.05, .2, .1, 2, .5)

# Should return:
#   n1  n2
#  704 352


}
