% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.condslope.log}
\alias{ci.condslope.log}
\title{Confidence intervals for conditional (simple) slopes in a logistic model}
\usage{
ci.condslope.log(alpha, b1, b2, se1, se2, cov, lo, hi)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{b1}{estimated slope coefficient for predictor variable}

\item{b2}{estimated slope coefficient for product variable}

\item{se1}{standard error for predictor coefficient}

\item{se2}{standard error for product coefficient}

\item{cov}{estimated covariance between predictor and product coefficients}

\item{lo}{low value of moderator variable}

\item{hi}{high value of moderator variable}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated conditional slope
\item exp(Estimate) - estimated exponentiated conditional slope
\item z - z test statistic
\item p - two-sided p-value
\item LL - lower limit of the exponentiated confidence interval
\item UL - upper limit of the exponentiated confidence interval
}
}
\description{
Computes confidence intervals and test statistics for population
conditional slopes (simple slopes) in a logistic model that
includes a predictor variable (x1), a moderator variable (x2),
and a product predictor variable (x1*x2). Conditional slopes are
computed at low and high values of the moderator variable.

For more details, see Section 4.9 of Bonett (2021, Volume 3)
}
\examples{
ci.condslope.log(.05, .132, .154, .031, .021, .015, 5.2, 10.6)

# Should return:
#                   Estimate exp(Estimate)      z       p 
# At low moderator    0.9328      2.541616 2.2698 0.02322 
# At high moderator   1.7644      5.838068 2.9065 0.00365 
#                          LL        UL
# At low moderator   1.135802  5.687444
# At high moderator  1.776421 19.186357


}
\references{
\insertRef{Bonett2021}{statpsych}
}
